/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui;

import jakarta.inject.Inject;
import java.util.Optional;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.ui.StageStatus;
import org.pdfsam.service.ui.StageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class WindowStatusController {
    private static final Logger LOG = LoggerFactory.getLogger(WindowStatusController.class);
    private Stage stage;
    private final StageService service;

    @Inject
    WindowStatusController(StageService service) {
        this.service = service;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
        this.initUi();
    }

    private void initUi() {
        StageStatus latestStatus = this.service.getLatestStatus();
        if (!Boolean.getBoolean("org.pdfsam.disable.ui.restore") && !StageStatus.NULL.equals((Object)latestStatus) && this.hasAvailableScreen(latestStatus)) {
            this.restore(latestStatus);
            LOG.trace("Stage status restored to {}", (Object)latestStatus);
        } else {
            this.defaultStageStatus();
            LOG.trace("Stage status set to default values");
        }
    }

    private void defaultStageStatus() {
        Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
        this.stage.setX((primScreenBounds.getWidth() - this.stage.getWidth()) / 2.0);
        this.stage.setY((primScreenBounds.getHeight() - this.stage.getHeight()) / 4.0);
        this.stage.setMaximized(true);
    }

    private void restore(StageStatus latestStatus) {
        this.stage.setX(latestStatus.x());
        this.stage.setY(latestStatus.y());
        this.stage.setWidth(latestStatus.width());
        this.stage.setHeight(latestStatus.height());
        if (this.isNotMac()) {
            latestStatus.mode().restore(this.stage);
        }
    }

    private boolean isNotMac() {
        return !Optional.of(System.getProperty("os.name")).orElse("").toLowerCase().contains("mac");
    }

    private boolean hasAvailableScreen(StageStatus status) {
        return !Screen.getScreensForRectangle((double)status.x(), (double)status.y(), (double)status.width(), (double)status.height()).isEmpty();
    }
}

