/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.update;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.pdfsam.core.AppBrand;
import org.pdfsam.core.BrandableProperty;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.service.update.UpdateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpdateService
implements UpdateService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUpdateService.class);
    private static final String CURRENT_VERSION_KEY = "currentVersion";
    private final ObjectMapper objectMapper;
    private final AppBrand appBrand;

    @Inject
    DefaultUpdateService(AppBrand appBrand, ObjectMapper objectMapper) {
        this.appBrand = appBrand;
        this.objectMapper = objectMapper;
    }

    @Override
    public String getLatestVersion() {
        try {
            return ((Map)this.objectMapper.readValue(new URL(String.format(this.appBrand.property(BrandableProperty.CURRENT_VERSION_URL), this.appBrand.property(BrandableProperty.VERSION))), Map.class)).getOrDefault(CURRENT_VERSION_KEY, "").toString();
        }
        catch (IOException e) {
            LOG.warn(I18nContext.i18n().tr("Unable to find the latest available version."), (Throwable)e);
            return "";
        }
    }
}

