/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.ui;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.pdfsam.model.ui.StageStatus;
import org.pdfsam.persistence.DefaultEntityRepository;
import org.pdfsam.persistence.PersistenceException;
import org.pdfsam.service.ui.StageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStageService
implements StageService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStageService.class);
    static final String STAGE_STATUS_KEY = "stage.status";
    private final DefaultEntityRepository<StageStatus> repo;

    @Inject
    DefaultStageService(@Named(value="stageStatusRepository") DefaultEntityRepository<StageStatus> repo) {
        this.repo = repo;
    }

    @Override
    public void save(StageStatus status) {
        try {
            this.repo.save(STAGE_STATUS_KEY, (Object)status);
            LOG.trace("Stage status saved {}", (Object)status);
        }
        catch (PersistenceException e) {
            LOG.error("Unable to save Stage status", (Throwable)e);
        }
    }

    @Override
    public StageStatus getLatestStatus() {
        try {
            return (StageStatus)this.repo.get(STAGE_STATUS_KEY, (Object)StageStatus.NULL);
        }
        catch (PersistenceException e) {
            LOG.error("Unable to get latest stage status", (Throwable)e);
            return StageStatus.NULL;
        }
    }

    @Override
    public void clear() {
        try {
            this.repo.clean();
        }
        catch (PersistenceException e) {
            LOG.error("Unable to clear stage status", (Throwable)e);
        }
    }
}

