/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.ui;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.model.lifecycle.ShutdownEvent;
import org.pdfsam.persistence.PersistenceException;
import org.pdfsam.persistence.PreferencesRepository;
import org.pdfsam.service.ui.RecentWorkspacesService;
import org.sejda.commons.collection.LRUMap;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRecentWorkspacesService
implements RecentWorkspacesService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRecentWorkspacesService.class);
    static final int MAX_CAPACITY = 20;
    private final PreferencesRepository repo;
    private final Map<String, String> cache = new LRUMap(20);

    @Inject
    public DefaultRecentWorkspacesService(@Named(value="recentWorkspacesRepository") PreferencesRepository repo) {
        this.repo = repo;
        this.populateCache();
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private void populateCache() {
        try {
            Arrays.stream(this.repo.keys()).sorted().forEach(k -> {
                String currentValue = this.repo.getString(k, "");
                if (StringUtils.isNotBlank((CharSequence)currentValue)) {
                    this.cache.put(currentValue, (String)k);
                }
            });
        }
        catch (PersistenceException e) {
            LOG.error("Error retrieving recently used workspaces", (Throwable)e);
        }
    }

    @Override
    public void addWorkspaceLastUsed(File workspace) {
        RequireUtils.requireNotNullArg((Object)workspace, (String)"Null workspace is not allowed");
        this.cache.put(workspace.getAbsolutePath(), Long.toString(Instant.now().toEpochMilli()));
        LOG.trace("Added recently used workspace {}", (Object)workspace.getAbsolutePath());
    }

    @Override
    public List<String> getRecentlyUsedWorkspaces() {
        return this.cache.entrySet().stream().sorted(Map.Entry.comparingByValue(Collections.reverseOrder())).map(Map.Entry::getKey).toList();
    }

    @Override
    public void clear() {
        this.cache.clear();
        try {
            this.repo.clean();
        }
        catch (PersistenceException e) {
            LOG.error("Unable to clear recently used workspaces", (Throwable)e);
        }
    }

    @EventListener
    public void onShutdown(ShutdownEvent event) {
        LOG.trace("Flushing recently used workspaces");
        try {
            this.repo.clean();
            this.cache.forEach((k, v) -> this.repo.saveString(v, k));
        }
        catch (PersistenceException e) {
            LOG.error("Error storing recently used workspace", (Throwable)e);
        }
    }
}

