/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.task;

import java.io.Closeable;
import java.io.File;
import org.pdfsam.model.task.BulkRotateParameters;
import org.pdfsam.model.task.PdfRotationInput;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfRotator;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.TaskSource;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkRotateTask
extends BaseTask<BulkRotateParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(BulkRotateTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    public void before(BulkRotateParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.totalSteps = parameters.getInputSet().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(BulkRotateParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfRotationInput input : parameters.getInputSet()) {
            ++currentStep;
            LOG.debug("Opening {}", (Object)input.source);
            try {
                this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)input.source);
                this.documentHandler = (PDDocumentHandler)input.source.open(this.documentLoader);
                this.documentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
                this.documentHandler.setCreatorOnPDDocument();
                File tmpFile = org.sejda.model.util.IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
                LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
                PdfRotator rotator = new PdfRotator(this.documentHandler.getUnderlyingPDDocument());
                for (Integer page : input.getPages(this.documentHandler.getNumberOfPages())) {
                    rotator.rotate(page.intValue(), input.rotation);
                }
                this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
                this.documentHandler.setCompress(parameters.isCompress());
                this.documentHandler.savePDDocument(tmpFile, parameters.getOutput().getEncryptionAtRestPolicy());
                String outName = NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(input.source.getName()).fileNumber(currentStep));
                this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
            }
            finally {
                IOUtils.closeQuietly((Closeable)this.documentHandler);
            }
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        this.executionContext().notifiableTaskMetadata().clearCurrentSource();
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Input documents rotated and written to {}", (Object)parameters.getOutput());
    }

    public void after() {
        IOUtils.closeQuietly((Closeable)this.documentHandler);
    }
}

