/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.premium;

import jakarta.inject.Inject;
import java.util.Optional;
import org.pdfsam.eventstudio.DefaultEventStudio;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.premium.FetchPremiumModulesRequest;
import org.pdfsam.model.premium.PremiumToolsResponse;
import org.pdfsam.service.premium.PremiumToolsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class PremiumToolsController {
    private static final Logger LOG = LoggerFactory.getLogger(PremiumToolsController.class);
    private final PremiumToolsService service;

    @Inject
    PremiumToolsController(PremiumToolsService service) {
        this.service = service;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void fetchPremium(FetchPremiumModulesRequest event) {
        Thread.ofVirtual().name("premium-tools-thread").start(() -> {
            LOG.debug(I18nContext.i18n().tr("Fetching premium modules"));
            try {
                Optional.ofNullable(this.service.getPremiumTools()).filter(l -> !l.isEmpty()).map(PremiumToolsResponse::new).ifPresent(arg_0 -> ((DefaultEventStudio)StaticStudio.eventStudio()).broadcast(arg_0));
            }
            catch (Exception e) {
                LOG.warn(I18nContext.i18n().tr("Unable to retrieve premium modules"), (Throwable)e);
            }
        });
    }
}

