/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.pdf;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfListParser
implements Function<Path, List<File>> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfListParser.class);

    PdfListParser() {
    }

    @Override
    public List<File> apply(Path listFile) {
        if (Objects.isNull(listFile)) {
            return Collections.emptyList();
        }
        List<Charset> charsets = List.of(StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1, Charset.defaultCharset());
        for (Charset charset : charsets) {
            try {
                return Files.lines(listFile, charset).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(PdfListParser::parseLine).map(String::trim).filter(s -> s.toUpperCase().endsWith("PDF")).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(Predicate.not(x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).map(Path::toFile).collect(Collectors.toList());
            }
            catch (UncheckedIOException e) {
                LOG.warn("Unable to read lines from " + String.valueOf(listFile) + " using charset " + String.valueOf(charset), (Throwable)e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        throw new RuntimeException("Unable to read lines from " + String.valueOf(listFile));
    }

    private static String parseLine(String line) {
        boolean hasQuotes = false;
        boolean lastWasQuote = false;
        StringBuilder field = new StringBuilder();
        for (char c : line.toCharArray()) {
            if (field.length() == 0 && c == '\"') {
                hasQuotes = true;
                continue;
            }
            if (c == ',' && !hasQuotes) {
                return field.toString();
            }
            if (c == ',' && lastWasQuote) {
                field.setLength(field.length() - 1);
                return field.toString();
            }
            lastWasQuote = c == '\"';
            field.append(c);
        }
        return field.toString();
    }
}

