/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.news;

import jakarta.inject.Inject;
import java.util.Optional;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.lifecycle.CleanupRequest;
import org.pdfsam.model.news.FetchLatestNewsRequest;
import org.pdfsam.model.news.LatestNewsResponse;
import org.pdfsam.model.news.NewImportantNewsEvent;
import org.pdfsam.model.news.NewsData;
import org.pdfsam.model.news.ToggleNewsPanelRequest;
import org.pdfsam.service.news.NewsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class NewsController {
    private static final Logger LOG = LoggerFactory.getLogger(NewsController.class);
    private final NewsService service;
    private int currentLatest = -1;

    @Inject
    NewsController(NewsService service) {
        this.service = service;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void fetchLatestNews(FetchLatestNewsRequest event) {
        Thread.ofVirtual().name("news-checker-thread").start(() -> {
            LOG.debug(I18nContext.i18n().tr("Fetching latest news"));
            try {
                Optional.ofNullable(this.service.getLatestNews()).filter(l -> !l.isEmpty()).ifPresent(news -> {
                    this.currentLatest = ((NewsData)news.get(0)).id();
                    StaticStudio.eventStudio().broadcast((Object)new LatestNewsResponse(news, this.service.getLatestNewsSeen() >= this.currentLatest));
                    news.stream().filter(NewsData::important).findFirst().filter(n -> this.service.getLatestImportantNewsSeen() < n.id()).ifPresent(n -> {
                        this.service.setLatestImportantNewsSeen(n.id());
                        StaticStudio.eventStudio().broadcast((Object)new NewImportantNewsEvent(n));
                    });
                });
            }
            catch (Exception e) {
                LOG.warn(I18nContext.i18n().tr("Unable to retrieve the latest news"), (Throwable)e);
            }
        });
    }

    @EventListener
    public void onShowNewsPanel(ToggleNewsPanelRequest req) {
        if (this.service.getLatestNewsSeen() < this.currentLatest) {
            this.service.setLatestNewsSeen(this.currentLatest);
        }
    }

    @EventListener
    public void onCleanupRequest(CleanupRequest req) {
        this.service.clear();
    }
}

