/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.SetLocaleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class I18nContext {
    private static final Logger LOG = LoggerFactory.getLogger(I18nContext.class);
    private final Set<Locale> supported = Set.of(Locale.of("af"), Locale.of("bs"), Locale.of("bg"), Locale.of("el"), Locale.of("eu"), Locale.of("pt", "BR"), Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.of("co"), Locale.of("ca"), Locale.of("hr"), Locale.of("cs"), Locale.of("da"), Locale.of("nl"), Locale.UK, Locale.FRENCH, Locale.GERMAN, Locale.of("he"), Locale.of("hi"), Locale.of("hu"), Locale.JAPANESE, Locale.ITALIAN, Locale.of("pl"), Locale.of("pt"), Locale.of("ro"), Locale.of("ru"), Locale.of("sk"), Locale.of("sl"), Locale.of("sr"), Locale.of("sv"), Locale.of("es"), Locale.of("tr"), Locale.of("uk"), Locale.of("fi"), Locale.of("ko"), Locale.of("oc"));
    private final SimpleObjectProperty<Locale> locale = new SimpleObjectProperty();
    private Optional<ResourceBundle> bundle = Optional.empty();

    I18nContext() {
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        this.locale.subscribe(this::loadBundles);
    }

    @EventListener
    public void setLocale(SetLocaleRequest e) {
        if (Objects.nonNull(e.languageTag()) && !e.languageTag().isBlank()) {
            LOG.trace("Setting locale to {}", (Object)e.languageTag());
            Optional.ofNullable(Locale.forLanguageTag(e.languageTag())).filter(this.supported::contains).ifPresent(arg_0 -> this.locale.set(arg_0));
        }
    }

    private void loadBundles(Locale l) {
        if (Objects.nonNull(l)) {
            Locale.setDefault(l);
            LOG.trace("Loading i18n bundle for {}", (Object)Locale.getDefault());
            try {
                this.bundle = Optional.ofNullable(ResourceBundle.getBundle("org.pdfsam.i18n.Messages", Locale.getDefault(), I18nContext.class.getModule()));
                LOG.debug("Locale set to {}", (Object)Locale.getDefault());
            }
            catch (Exception e) {
                LOG.error("Unable to load translations bundle", (Throwable)e);
            }
        }
    }

    Locale getBestLocale() {
        if (this.supported.contains(Locale.getDefault())) {
            LOG.trace("Using best matching locale: {}", (Object)Locale.getDefault());
            return Locale.getDefault();
        }
        Locale onlyLanguage = Locale.of(Locale.getDefault().getLanguage());
        if (this.supported.contains(onlyLanguage)) {
            LOG.trace("Using supported locale closest to default {}", (Object)onlyLanguage);
            return onlyLanguage;
        }
        LOG.trace("Using fallback locale");
        return Locale.ENGLISH;
    }

    public static I18nContext i18n() {
        return I18nContextHolder.CONTEXT;
    }

    public ObservableValue<Locale> locale() {
        return this.locale;
    }

    public String tr(String text) {
        this.initBundleIfRequired();
        return this.bundle.filter(r -> r.containsKey(text)).map(r -> r.getString(text)).orElse(text);
    }

    public String tr(String text, String ... replace) {
        this.initBundleIfRequired();
        return MessageFormat.format(this.tr(text), replace);
    }

    private void initBundleIfRequired() {
        if (this.bundle.isEmpty()) {
            this.locale.set((Object)this.getBestLocale());
        }
    }

    public Set<Locale> getSupported() {
        return this.supported;
    }

    private static final class I18nContextHolder {
        static final I18nContext CONTEXT = new I18nContext();

        private I18nContextHolder() {
        }
    }
}

