/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.alternatemix;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.pdfsam.core.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.core.support.params.SingleOutputTaskParametersBuilder;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.tools.alternatemix.AlternateMixParametersBuilder;
import org.pdfsam.tools.alternatemix.AlternateMixSelectionPane;
import org.pdfsam.ui.components.io.BrowsablePdfOutputField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.support.Views;
import org.pdfsam.ui.components.tool.BaseToolPanel;
import org.pdfsam.ui.components.tool.Footer;

public class AlternateMixToolPanel
extends BaseToolPanel {
    private final AlternateMixSelectionPane selectionPane = new AlternateMixSelectionPane("alternatemix");
    private final BrowsablePdfOutputField destinationFileField;
    private final PdfDestinationPane destinationPane;

    @Inject
    public AlternateMixToolPanel(@Named(value="alternatemixfield") BrowsablePdfOutputField destinationFileField, @Named(value="alternatemixpane") PdfDestinationPane destinationPane, @Named(value="alternatemixfooter") Footer footer) {
        super("alternatemix", footer);
        this.destinationFileField = destinationFileField;
        this.destinationPane = destinationPane;
        this.initModuleSettingsPanel(this.settingPanel());
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.destinationFileField.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        if (data.containsKey("firstDocumentMixinput")) {
            data.put("input.0", data.get("firstDocumentMixinput"));
            data.put("input.password.0", data.get("firstDocumentMixinputinput.password"));
            data.put("input.step.0", data.get("firstStep"));
            data.put("input.reverse.0", data.get("reverseFirst"));
            data.put("input.size", "1");
            if (data.containsKey("secondDocumentMixinput")) {
                data.put("input.1", data.get("secondDocumentMixinput"));
                data.put("input.password.1", data.get("secondDocumentMixinput.password"));
                data.put("input.step.1", data.get("secondStep"));
                data.put("input.reverse.1", data.get("reverseSecond"));
                data.put("input.size", "2");
            }
        }
        this.selectionPane.restoreStateFrom(data);
        this.destinationFileField.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
    }

    protected AlternateMixParametersBuilder getBuilder(Consumer<String> onError) {
        AlternateMixParametersBuilder builder = new AlternateMixParametersBuilder();
        this.selectionPane.apply(builder, onError);
        this.destinationFileField.apply((SingleOutputTaskParametersBuilder)builder, onError);
        this.destinationPane.apply((AbstractPdfOutputParametersBuilder)builder, onError);
        return builder;
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.selectionPane, (Priority)Priority.ALWAYS);
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane((String)I18nContext.i18n().tr("Destination file"), (Node)this.destinationPane)});
        return pane;
    }

    @EventStation
    public String id() {
        return "alternatemix";
    }

    @EventListener
    public void onClearModule(ClearToolRequest e) {
        if (e.clearEverything()) {
            this.destinationPane.resetView();
        }
    }
}

