/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.backpages;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.params.ConversionUtils;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.core.support.validation.Validator;
import org.pdfsam.core.support.validation.Validators;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.tools.backpages.AddBackpagesParametersBuilder;
import org.pdfsam.ui.components.commons.ValidableTextField;
import org.pdfsam.ui.components.selection.single.SingleSelectionPane;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;
import org.sejda.conversion.PdfFileSourceAdapter;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.pdf.page.PageRange;

public class AddBackpagesPane
extends VBox
implements TaskParametersBuildStep<AddBackpagesParametersBuilder>,
RestorableView,
ResettableView {
    private final SingleSelectionPane backpagesSourceField;
    private final ValidableTextField range = new ValidableTextField();
    private final ValidableTextField pace = new ValidableTextField();

    public AddBackpagesPane(String ownerModule) {
        super(5.0);
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.VCONTAINER.css());
        this.backpagesSourceField = new SingleSelectionPane(ownerModule, false);
        this.backpagesSourceField.setPromptText(I18nContext.i18n().tr("Select or drag and drop the PDF whose pages will be repeated"));
        this.backpagesSourceField.setId("backpagesSource");
        GridPane options = new GridPane();
        options.getStyleClass().addAll((Object[])Style.GRID.css());
        Label repeatLabel = new Label(I18nContext.i18n().tr("Repeat these pages:"));
        GridPane.setValignment((Node)repeatLabel, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)repeatLabel, (HPos)HPos.LEFT);
        options.add((Node)repeatLabel, 0, 0);
        this.range.setOnEnterValidation(true);
        this.range.setEnableInvalidStyle(true);
        this.range.setPromptText(I18nContext.i18n().tr("Pages to repeat (ex: 2 or 5-23 or 2,5-7,12-)"));
        this.range.setValidator(Validators.validEmpty(v -> {
            try {
                return !ConversionUtils.toPageRangeSet((String)this.range.getText()).isEmpty();
            }
            catch (ConversionException e) {
                return false;
            }
        }));
        this.range.setErrorMessage(I18nContext.i18n().tr("Invalid page ranges"));
        this.range.setId("selectedBackpages");
        this.range.setPrefWidth(350.0);
        GridPane.setValignment((Node)this.range, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)this.range, (HPos)HPos.LEFT);
        options.add((Node)this.range, 1, 0);
        Text rangeHelpIcon = Views.helpIcon((String)"%s.\n%s\n".formatted(I18nContext.i18n().tr("Comma separated page numbers or ranges to be repeated (ex: 2 or 5-23 or 2,5-7,12-)"), I18nContext.i18n().tr("Leave it empty to use all the pages of the PDF file")));
        GridPane.setValignment((Node)rangeHelpIcon, (VPos)VPos.CENTER);
        options.add((Node)rangeHelpIcon, 2, 0);
        Label paceLabel = new Label(I18nContext.i18n().tr("Repeat every \"n\" pages:"));
        GridPane.setValignment((Node)paceLabel, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)paceLabel, (HPos)HPos.LEFT);
        options.add((Node)paceLabel, 0, 1);
        this.pace.setText("1");
        this.pace.setOnEnterValidation(true);
        this.pace.setEnableInvalidStyle(true);
        this.pace.setPromptText(I18nContext.i18n().tr("Number of pages"));
        this.pace.setValidator(Validators.validEmpty((Validator)Validators.positiveInteger()));
        this.pace.setErrorMessage(I18nContext.i18n().tr("Invalid page number"));
        this.pace.setId("repeatPace");
        this.pace.setPrefWidth(350.0);
        GridPane.setValignment((Node)this.pace, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)this.pace, (HPos)HPos.LEFT);
        options.add((Node)this.pace, 1, 1);
        Text stepHelpIcon = Views.helpIcon((String)I18nContext.i18n().tr("Repeat the selected pages every \"n\" pages of the original document"));
        GridPane.setValignment((Node)stepHelpIcon, (VPos)VPos.CENTER);
        options.add((Node)stepHelpIcon, 2, 1);
        this.getChildren().addAll((Object[])new Node[]{this.backpagesSourceField, options});
    }

    public void apply(AddBackpagesParametersBuilder builder, Consumer<String> onError) {
        ValidableTextField textField = this.backpagesSourceField.getField().getTextField();
        textField.validate();
        if (textField.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            builder.backPagesSource(new PdfFileSourceAdapter(textField.getText()).getPdfFileSource());
        } else {
            onError.accept(I18nContext.i18n().tr("A .pdf extension is required for the repeating file"));
        }
        this.pace.validate();
        if (this.pace.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            if (StringUtils.isNotBlank((CharSequence)this.pace.getText())) {
                builder.step(Integer.parseInt(this.pace.getText()));
            } else {
                builder.step(1);
            }
        } else {
            onError.accept(I18nContext.i18n().tr("The number of pages must be a positive number"));
        }
        this.range.validate();
        if (this.range.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            if (StringUtils.isNotBlank((CharSequence)this.range.getText())) {
                try {
                    builder.ranges((Set<PageRange>)ConversionUtils.toPageRangeSet((String)this.range.getText()));
                }
                catch (ConversionException e) {
                    onError.accept(e.getMessage());
                }
            }
        } else {
            onError.accept(I18nContext.i18n().tr("Invalid page ranges"));
        }
    }

    public void resetView() {
        this.range.setText("");
        this.pace.setText("1");
    }

    public void saveStateTo(Map<String, String> data) {
        this.backpagesSourceField.saveStateTo(data);
        data.put("range.field", StringUtils.defaultString((String)this.range.getText()));
        data.put("pace.field", StringUtils.defaultString((String)this.pace.getText()));
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.backpagesSourceField.restoreStateFrom(data);
        this.range.setText(Optional.ofNullable(data.get("range.field")).orElse(""));
        this.pace.setText(Optional.ofNullable(data.get("pace.field")).orElse(""));
    }
}

