/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.util.filetypedetector;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.sambox.util.filetypedetector.ByteTrie;
import org.sejda.sambox.util.filetypedetector.FileType;

public final class FileTypeDetector {
    private static final ByteTrie<FileType> ROOT = new ByteTrie();
    private static final HashMap<String, FileType> FTYP_MAP;

    private FileTypeDetector() {
    }

    public static FileType detectFileType(File file) throws IOException {
        return FileTypeDetector.detectFileType(SeekableSources.seekableSourceFrom((File)file));
    }

    public static FileType detectFileType(SeekableSource source) throws IOException {
        String fourCC;
        byte[] firstBytes = new byte[ROOT.getMaxDepth()];
        try (InputStream fin = source.asNewInputStream();){
            fin.read(firstBytes);
        }
        FileType fileType = ROOT.find(firstBytes);
        if (fileType == FileType.UNKNOWN) {
            String eightCC = new String(firstBytes, 4, 8);
            FileType t = FTYP_MAP.get(eightCC);
            if (t != null) {
                return t;
            }
        } else if (fileType == FileType.RIFF && (fourCC = new String(firstBytes, 8, 4)).equals("WEBP")) {
            return FileType.WEBP;
        }
        return fileType;
    }

    static {
        ROOT.setDefaultValue(FileType.UNKNOWN);
        ROOT.addPath(FileType.JPEG, new byte[][]{{-1, -40}});
        ROOT.addPath(FileType.TIFF, "II".getBytes(StandardCharsets.ISO_8859_1), {42, 0});
        ROOT.addPath(FileType.TIFF, "MM".getBytes(StandardCharsets.ISO_8859_1), {0, 42});
        ROOT.addPath(FileType.PSD, new byte[][]{"8BPS".getBytes(StandardCharsets.ISO_8859_1)});
        ROOT.addPath(FileType.PNG, new byte[][]{{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82}});
        ROOT.addPath(FileType.BMP, new byte[][]{"BM".getBytes(StandardCharsets.ISO_8859_1)});
        ROOT.addPath(FileType.GIF, new byte[][]{"GIF87a".getBytes(StandardCharsets.ISO_8859_1)});
        ROOT.addPath(FileType.GIF, new byte[][]{"GIF89a".getBytes(StandardCharsets.ISO_8859_1)});
        ROOT.addPath(FileType.ICO, new byte[][]{{0, 0, 1, 0}});
        ROOT.addPath(FileType.PCX, new byte[][]{{10, 0, 1}});
        ROOT.addPath(FileType.PCX, new byte[][]{{10, 2, 1}});
        ROOT.addPath(FileType.PCX, new byte[][]{{10, 3, 1}});
        ROOT.addPath(FileType.PCX, new byte[][]{{10, 5, 1}});
        ROOT.addPath(FileType.RIFF, new byte[][]{"RIFF".getBytes(StandardCharsets.ISO_8859_1)});
        ROOT.addPath(FileType.CRW, "II".getBytes(StandardCharsets.ISO_8859_1), {26, 0, 0, 0}, "HEAPCCDR".getBytes(StandardCharsets.ISO_8859_1));
        ROOT.addPath(FileType.CR2, "II".getBytes(StandardCharsets.ISO_8859_1), {42, 0, 16, 0, 0, 0, 67, 82});
        ROOT.addPath(FileType.NEF, "MM".getBytes(StandardCharsets.ISO_8859_1), {0, 42, 0, 0, 0, -128, 0});
        ROOT.addPath(FileType.ORF, "IIRO".getBytes(StandardCharsets.ISO_8859_1), {8, 0});
        ROOT.addPath(FileType.ORF, "IIRS".getBytes(StandardCharsets.ISO_8859_1), {8, 0});
        ROOT.addPath(FileType.RAF, new byte[][]{"FUJIFILMCCD-RAW".getBytes(StandardCharsets.ISO_8859_1)});
        ROOT.addPath(FileType.RW2, "II".getBytes(StandardCharsets.ISO_8859_1), {85, 0});
        FTYP_MAP = new HashMap();
        FTYP_MAP.put("ftypmif1", FileType.HEIF);
        FTYP_MAP.put("ftypmsf1", FileType.HEIF);
        FTYP_MAP.put("ftypheic", FileType.HEIF);
        FTYP_MAP.put("ftypheix", FileType.HEIF);
        FTYP_MAP.put("ftyphevc", FileType.HEIF);
        FTYP_MAP.put("ftyphevx", FileType.HEIF);
    }
}

