/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.Bidi;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sejda.sambox.util.CharUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BidiUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BidiUtils.class);
    private static Map<Character, Character> MIRRORING_CHAR_MAP = new HashMap<Character, Character>();

    private BidiUtils() {
    }

    public static String visualToLogical(String text) {
        Bidi bidi;
        if (!CharUtils.isBlank(text) && !(bidi = new Bidi(text, -2)).isLeftToRight()) {
            int runCount = bidi.getRunCount();
            byte[] levels = new byte[runCount];
            Object[] runs = new Integer[runCount];
            for (int i = 0; i < runCount; ++i) {
                levels[i] = (byte)bidi.getRunLevel(i);
                runs[i] = i;
            }
            Bidi.reorderVisually(levels, 0, runs, 0, runCount);
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < runCount; ++i) {
                int index = (Integer)runs[i];
                int start = bidi.getRunStart(index);
                int end = bidi.getRunLimit(index);
                byte level = levels[index];
                if ((level & 1) != 0) {
                    while (--end >= start) {
                        char character = text.charAt(end);
                        if (Character.isMirrored(text.codePointAt(end)) && MIRRORING_CHAR_MAP.containsKey(Character.valueOf(character))) {
                            result.append(MIRRORING_CHAR_MAP.get(Character.valueOf(character)));
                            continue;
                        }
                        result.append(character);
                    }
                    continue;
                }
                result.append(text, start, end);
            }
            return result.toString();
        }
        return text;
    }

    private static void parseBidiFile(InputStream inputStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            reader.lines().map(l -> {
                int comment = l.indexOf(35);
                if (comment != -1) {
                    return l.substring(0, comment);
                }
                return l;
            }).filter(l -> !CharUtils.isBlank(l)).filter(l -> l.length() > 1).forEach(l -> {
                String[] tokens = l.split(";");
                if (tokens.length == 2) {
                    MIRRORING_CHAR_MAP.put(Character.valueOf((char)Integer.parseInt(tokens[0].trim(), 16)), Character.valueOf((char)Integer.parseInt(tokens[1].trim(), 16)));
                }
            });
        }
        catch (IOException e) {
            LOG.warn("An error occurred while parsing BidiMirroring.txt", (Throwable)e);
        }
    }

    static {
        InputStream stream = BidiUtils.class.getResourceAsStream("/org/sejda/sambox/resources/text/BidiMirroring.txt");
        if (Objects.nonNull(stream)) {
            BidiUtils.parseBidiFile(stream);
        } else {
            LOG.warn("Could not find 'BidiMirroring.txt', mirroring char map will be empty");
        }
    }
}

