/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;

public class PDFieldTree
implements Iterable<PDField> {
    private final PDAcroForm acroForm;

    public PDFieldTree(PDAcroForm acroForm) {
        RequireUtils.requireNotNullArg((Object)acroForm, (String)"root cannot be null");
        this.acroForm = acroForm;
    }

    @Override
    public Iterator<PDField> iterator() {
        return new FieldIterator(this.acroForm);
    }

    public Stream<PDField> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new PreOrderIterator(this.acroForm), 272), false);
    }

    private static final class FieldIterator
    implements Iterator<PDField> {
        private final Queue<PDField> queue = new ArrayDeque<PDField>();

        private FieldIterator(PDAcroForm form) {
            for (PDField field : form.getFields()) {
                this.enqueueKids(field);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public PDField next() {
            return this.queue.remove();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void enqueueKids(PDField node) {
            if (node instanceof PDNonTerminalField) {
                List<PDField> kids = ((PDNonTerminalField)node).getChildren();
                for (PDField kid : kids) {
                    this.enqueueKids(kid);
                }
            }
            this.queue.add(node);
        }
    }

    private static final class PreOrderIterator
    implements Iterator<PDField> {
        private final Deque<PDField> queue = new ArrayDeque<PDField>();

        private PreOrderIterator(PDAcroForm form) {
            for (PDField field : form.getFields()) {
                this.enqueueKids(field);
            }
        }

        private void enqueueKids(PDField node) {
            this.queue.add(node);
            if (node instanceof PDNonTerminalField) {
                List<PDField> kids = ((PDNonTerminalField)node).getChildren();
                for (PDField kid : kids) {
                    this.enqueueKids(kid);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public PDField next() {
            return this.queue.remove();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

