/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel;

import java.util.Optional;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.PDDestinationNameTreeNode;
import org.sejda.sambox.pdmodel.PDDocumentCatalog;
import org.sejda.sambox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.sejda.sambox.pdmodel.PDJavascriptNameTreeNode;

public class PDDocumentNameDictionary
implements COSObjectable {
    private final COSDictionary nameDictionary;

    public PDDocumentNameDictionary(PDDocumentCatalog catalog) {
        this.nameDictionary = Optional.ofNullable(catalog.getCOSObject().getDictionaryObject(COSName.NAMES, COSDictionary.class)).orElseGet(COSDictionary::new);
        catalog.getCOSObject().putIfAbsent(COSName.NAMES, this.nameDictionary);
    }

    public PDDocumentNameDictionary(COSDictionary names) {
        this.nameDictionary = names;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.nameDictionary;
    }

    public PDDestinationNameTreeNode getDests() {
        return Optional.ofNullable(this.nameDictionary.getDictionaryObject(COSName.DESTS, COSDictionary.class)).map(PDDestinationNameTreeNode::new).orElse(null);
    }

    public void setDests(PDDestinationNameTreeNode dests) {
        this.nameDictionary.setItem(COSName.DESTS, (COSObjectable)dests);
    }

    public PDEmbeddedFilesNameTreeNode getEmbeddedFiles() {
        return Optional.ofNullable(this.nameDictionary.getDictionaryObject(COSName.EMBEDDED_FILES, COSDictionary.class)).map(PDEmbeddedFilesNameTreeNode::new).orElse(null);
    }

    public void setEmbeddedFiles(PDEmbeddedFilesNameTreeNode ef) {
        this.nameDictionary.setItem(COSName.EMBEDDED_FILES, (COSObjectable)ef);
    }

    public PDJavascriptNameTreeNode getJavaScript() {
        return Optional.ofNullable(this.nameDictionary.getDictionaryObject(COSName.JAVA_SCRIPT, COSDictionary.class)).map(PDJavascriptNameTreeNode::new).orElse(null);
    }

    public void setJavascript(PDJavascriptNameTreeNode js) {
        this.nameDictionary.setItem(COSName.JAVA_SCRIPT, (COSObjectable)js);
    }
}

