/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.cos.IndirectCOSObjectIdentifier;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.encryption.GeneralEncryptionAlgorithm;
import org.sejda.sambox.input.ExistingIndirectCOSObject;
import org.sejda.sambox.output.IndirectReferenceProvider;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.xref.XrefEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PDFWriteContext {
    private static final Logger LOG = LoggerFactory.getLogger(PDFWriteContext.class);
    private final String contextId = UUID.randomUUID().toString();
    private final IndirectReferenceProvider referencesProvider;
    private final Map<IndirectCOSObjectIdentifier, IndirectCOSObjectReference> lookupNewRef = new ConcurrentHashMap<IndirectCOSObjectIdentifier, IndirectCOSObjectReference>();
    private final List<WriteOption> opts;
    private final SortedMap<Long, XrefEntry> written = new ConcurrentSkipListMap<Long, XrefEntry>();
    private final GeneralEncryptionAlgorithm encryptor;

    PDFWriteContext(GeneralEncryptionAlgorithm encryptor, WriteOption ... options) {
        this(0L, encryptor, options);
    }

    PDFWriteContext(long highestExistingReferenceNumber, GeneralEncryptionAlgorithm encryptor, WriteOption ... options) {
        this.encryptor = encryptor;
        this.opts = Arrays.asList(options);
        this.referencesProvider = new IndirectReferenceProvider(highestExistingReferenceNumber);
        LOG.debug("PDFWriteContext created with highest object reference number {} and encryptor {}", (Object)highestExistingReferenceNumber, (Object)encryptor);
    }

    IndirectCOSObjectReference createIndirectReferenceFor(COSBase item) {
        return this.createNewReference(item, this.referencesProvider::nextReferenceFor);
    }

    IndirectCOSObjectReference createNonStorableInObjectStreamIndirectReferenceFor(COSBase item) {
        return this.createNewReference(item, this.referencesProvider::nextNonStorableInObjectStreamsReferenceFor);
    }

    IndirectCOSObjectReference createNonStorableInObjectStreamIndirectReference() {
        return this.referencesProvider.nextNonStorableInObjectStreamsReference();
    }

    private IndirectCOSObjectReference createNewReference(COSBase item, Function<COSBase, IndirectCOSObjectReference> supplier) {
        IndirectCOSObjectReference newRef = supplier.apply(item);
        LOG.trace("Created new indirect reference {} for {}", (Object)newRef, (Object)item.id());
        if (!(item instanceof ExistingIndirectCOSObject)) {
            item.idIfAbsent(new IndirectCOSObjectIdentifier(newRef.xrefEntry().key(), this.contextId));
        }
        if (item.hasId()) {
            this.lookupNewRef.put(item.id(), newRef);
        } else {
            LOG.warn("Unexpected indirect reference for {}", (Object)item);
        }
        return newRef;
    }

    IndirectCOSObjectReference getOrCreateIndirectReferenceFor(COSBase item) {
        return Optional.ofNullable(this.getIndirectReferenceFor(item)).orElseGet(() -> this.createIndirectReferenceFor(item));
    }

    IndirectCOSObjectReference getIndirectReferenceFor(COSBase item) {
        if (item.hasId()) {
            return this.lookupNewRef.get(item.id());
        }
        return null;
    }

    void addExistingReference(ExistingIndirectCOSObject existing) {
        this.lookupNewRef.put(existing.id(), new IndirectCOSObjectReference(existing.id().objectIdentifier.objectNumber(), existing.id().objectIdentifier.generation(), null));
    }

    boolean hasIndirectReferenceFor(COSBase item) {
        return item.hasId() && this.lookupNewRef.containsKey(item.id());
    }

    boolean hasWriteOption(WriteOption opt) {
        return this.opts.contains((Object)opt);
    }

    int written() {
        return this.written.size();
    }

    boolean hasWritten(XrefEntry entry) {
        return this.written.containsKey(entry.getObjectNumber());
    }

    XrefEntry addWritten(XrefEntry entry) {
        return this.written.put(entry.getObjectNumber(), entry);
    }

    XrefEntry highestWritten() {
        return (XrefEntry)this.written.get(this.written.lastKey());
    }

    long highestObjectNumber() {
        if (this.written.isEmpty()) {
            return this.referencesProvider.referencesCounter.get();
        }
        return Math.max(this.written.lastKey(), this.referencesProvider.referencesCounter.get());
    }

    XrefEntry getWritten(Long objectNumber) {
        return (XrefEntry)this.written.get(objectNumber);
    }

    List<List<Long>> getWrittenContiguousGroups() {
        ArrayList<List<Long>> contiguous = new ArrayList<List<Long>>();
        if (!this.written.isEmpty()) {
            LinkedList<Long> group = new LinkedList<Long>();
            contiguous.add(group);
            for (Long current : this.written.keySet()) {
                if (group.isEmpty() || current == (Long)group.getLast() + 1L) {
                    group.addLast(current);
                    continue;
                }
                group = new LinkedList<Long>(List.of(current));
                contiguous.add(group);
            }
        }
        return contiguous;
    }

    void writing(COSObjectKey key) {
        if (Objects.nonNull(this.encryptor)) {
            this.encryptor.setCurrentCOSObjectKey(key);
        }
    }

    GeneralEncryptionAlgorithm encryptor() {
        return this.encryptor;
    }
}

