/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.sambox.cos.COSDocument;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.encryption.EncryptionContext;
import org.sejda.sambox.output.AsyncPDFBodyObjectsWriter;
import org.sejda.sambox.output.DefaultPDFWriter;
import org.sejda.sambox.output.IndirectObjectsWriter;
import org.sejda.sambox.output.ObjectsStreamPDFBodyObjectsWriter;
import org.sejda.sambox.output.PDFBodyObjectsWriter;
import org.sejda.sambox.output.PDFBodyWriter;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.output.SyncPDFBodyObjectsWriter;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.common.PDDictionaryWrapper;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDDocumentWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PDDocumentWriter.class);
    private DefaultPDFWriter writer;
    private PDFWriteContext context;
    private Optional<EncryptionContext> encryptionContext;

    public PDDocumentWriter(CountingWritableByteChannel channel, Optional<EncryptionContext> encryptionContext, WriteOption ... options) {
        RequireUtils.requireNotNullArg((Object)channel, (String)"Cannot write to a null channel");
        this.encryptionContext = Optional.ofNullable(encryptionContext).orElseGet(Optional::empty);
        this.context = new PDFWriteContext(this.encryptionContext.map(EncryptionContext::encryptionAlgorithm).orElse(null), options);
        this.writer = new DefaultPDFWriter(new IndirectObjectsWriter(channel, this.context));
    }

    public void write(PDDocument document) throws IOException {
        RequireUtils.requireNotNullArg((Object)document, (String)"PDDocument cannot be null");
        if (this.context.hasWriteOption(WriteOption.XREF_STREAM) || this.context.hasWriteOption(WriteOption.OBJECT_STREAMS)) {
            document.requireMinVersion("1.5");
        }
        Optional.ofNullable(document.getDocument().getTrailer()).map(PDDictionaryWrapper::getCOSObject).ifPresent(t -> t.removeItem(COSName.ENCRYPT));
        this.encryptionContext.ifPresent(c -> {
            document.getDocument().setEncryptionDictionary(c.security.encryption.generateEncryptionDictionary((EncryptionContext)c));
            LOG.debug("Generated encryption dictionary");
            Optional.ofNullable(document.getDocumentCatalog().getMetadata()).map(PDStream::getCOSObject).ifPresent(str -> str.encryptable(c.security.encryptMetadata));
        });
        this.writer.writeHeader(document.getDocument().getHeaderVersion());
        this.writeBody(document.getDocument());
        this.writeXref(document);
    }

    private void writeBody(COSDocument document) throws IOException {
        try (PDFBodyWriter bodyWriter = new PDFBodyWriter(this.context, this.objectStreamWriter(this.objectsWriter()));){
            LOG.debug("Writing body using " + bodyWriter.objectsWriter.getClass());
            bodyWriter.write(document);
        }
    }

    private PDFBodyObjectsWriter objectsWriter() {
        if (this.context.hasWriteOption(WriteOption.ASYNC_BODY_WRITE)) {
            return new AsyncPDFBodyObjectsWriter(this.writer.writer());
        }
        return new SyncPDFBodyObjectsWriter(this.writer.writer());
    }

    private PDFBodyObjectsWriter objectStreamWriter(PDFBodyObjectsWriter wrapped) {
        if (this.context.hasWriteOption(WriteOption.OBJECT_STREAMS)) {
            return new ObjectsStreamPDFBodyObjectsWriter(this.context, wrapped);
        }
        return wrapped;
    }

    private void writeXref(PDDocument document) throws IOException {
        if (this.context.hasWriteOption(WriteOption.XREF_STREAM) || this.context.hasWriteOption(WriteOption.OBJECT_STREAMS)) {
            this.writer.writeXrefStream(document.getDocument().getTrailer().getCOSObject());
        } else {
            long startxref = this.writer.writeXrefTable();
            this.writer.writeTrailer(document.getDocument().getTrailer().getCOSObject(), startxref);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.writer);
    }
}

