/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.splitbysize;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.builder.Builder;
import org.pdfsam.core.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.core.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.core.support.params.SinglePdfSourceTaskParametersBuilder;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.tools.splitbysize.SplitBySizeParametersBuilder;
import org.pdfsam.tools.splitbysize.SplitOptionsPane;
import org.pdfsam.ui.components.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.prefix.PrefixPane;
import org.pdfsam.ui.components.selection.single.TaskParametersBuilderSingleSelectionPane;
import org.pdfsam.ui.components.support.Views;
import org.pdfsam.ui.components.tool.BaseToolPanel;
import org.pdfsam.ui.components.tool.Footer;
import org.sejda.model.parameter.SplitBySizeParameters;
import org.sejda.model.prefix.Prefix;

public class SplitBySizeToolPanel
extends BaseToolPanel {
    private final TaskParametersBuilderSingleSelectionPane selectionPane;
    private final BrowsableOutputDirectoryField destinationDirectoryField;
    private final PdfDestinationPane destinationPane;
    private final SplitOptionsPane splitOptions = new SplitOptionsPane();
    private final PrefixPane prefix;

    @Inject
    public SplitBySizeToolPanel(@Named(value="split.bysizefield") BrowsableOutputDirectoryField destinationDirectoryField, @Named(value="split.bysizepane") PdfDestinationPane destinationPane, @Named(value="split.bysizefooter") Footer footer, @Named(value="split.bysizeprefix") PrefixPane prefix) {
        super("split.bysize", footer);
        this.destinationDirectoryField = destinationDirectoryField;
        this.destinationPane = destinationPane;
        this.selectionPane = new TaskParametersBuilderSingleSelectionPane(this.id());
        this.selectionPane.setPromptText(I18nContext.i18n().tr("Select or drag and drop the PDF you want to split"));
        this.prefix = prefix;
        this.initModuleSettingsPanel(this.settingPanel());
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.splitOptions.saveStateTo(data);
        this.destinationDirectoryField.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
        this.prefix.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.splitOptions.restoreStateFrom(data);
        this.destinationDirectoryField.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
        this.prefix.restoreStateFrom(data);
    }

    protected Builder<SplitBySizeParameters> getBuilder(Consumer<String> onError) {
        SplitBySizeParametersBuilder builder = new SplitBySizeParametersBuilder();
        this.splitOptions.apply(builder, onError);
        this.selectionPane.apply((SinglePdfSourceTaskParametersBuilder)builder, onError);
        this.destinationDirectoryField.apply((MultipleOutputTaskParametersBuilder)builder, onError);
        this.destinationPane.apply((AbstractPdfOutputParametersBuilder)builder, onError);
        this.prefix.apply((MultipleOutputTaskParametersBuilder)builder, onError);
        return builder;
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        TitledPane prefixTitled = Views.titledPane((String)I18nContext.i18n().tr("File names settings"), (Node)this.prefix);
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.CURRENTPAGE});
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.FILENUMBER});
        this.prefix.addMenuItemFor(new String[]{"[TOTAL_FILESNUMBER]"});
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane((String)I18nContext.i18n().tr("Split settings"), (Node)this.splitOptions), Views.titledPane((String)I18nContext.i18n().tr("Output settings"), (Node)this.destinationPane), prefixTitled});
        return pane;
    }

    @EventListener
    public void onClearModule(ClearToolRequest e) {
        if (e.clearEverything()) {
            this.splitOptions.resetView();
            this.prefix.resetView();
            this.destinationPane.resetView();
        }
    }

    @EventStation
    public String id() {
        return "split.bysize";
    }
}

