/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.tool;

import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Prototype;
import org.pdfsam.model.tool.TaskExecutionRequest;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.tool.RunButtonTriggerRequest;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;

@Prototype
public class RunButton
extends Button {
    public RunButton() {
        this.getStyleClass().addAll((Object[])Style.RUN_BUTTON.css());
        this.setText(I18nContext.i18n().tr("Run"));
        this.setTooltip(new Tooltip(I18nContext.i18n().tr("Run the task") + " (" + RunButtonTriggerRequest.KEY_CODE_COMBINATION.getDisplayText() + ")"));
        this.setGraphic((Node)FontIcon.of((Ikon)UniconsLine.PLAY));
        this.setMaxHeight(Double.MAX_VALUE);
        this.setPrefHeight(Double.MAX_VALUE);
        this.setDefaultButton(true);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void disableRunButtonIfTaskRequested(TaskExecutionRequest event) {
        this.setDisable(true);
    }

    @EventListener
    public void enableRunButtonOnTaskCompletion(TaskExecutionCompletedEvent event) {
        this.setDisable(false);
    }

    @EventListener
    public void enableRunButtonOnTaskFailure(TaskExecutionFailedEvent event) {
        this.setDisable(false);
    }
}

