/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.tool;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitMenuButton;
import org.apache.commons.lang3.StringUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.eventstudio.ReferenceStrength;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.io.NativeOpenFileRequest;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.pdfsam.model.pdf.PdfLoadRequest;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.model.tool.TaskExecutionRequest;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.tool.ToolInputOutputType;
import org.pdfsam.model.ui.SetActiveContentItemRequest;
import org.pdfsam.ui.components.support.Style;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenButton
extends SplitMenuButton
implements TaskOutputDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(OpenButton.class);
    private final String ownerModule;
    private File destination;
    private final List<File> latestOutput = new ArrayList<File>();

    public OpenButton(String ownerTool, ToolInputOutputType outputType) {
        this(ownerTool, outputType, ApplicationContext.app().runtimeState().tools().values());
    }

    OpenButton(String ownerModule, ToolInputOutputType outputType, Collection<Tool> tools) {
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
        this.setId(ownerModule + ".openButton");
        this.getStyleClass().addAll((Object[])Style.BUTTON.css());
        this.getStyleClass().addAll((Object[])new String[]{"pdfsam-split-button", "footer-open-button"});
        this.setText(I18nContext.i18n().tr("Open"));
        this.setMaxHeight(Double.MAX_VALUE);
        this.setPrefHeight(Double.MAX_VALUE);
        this.setVisible(false);
        this.setOnAction(e -> {
            if (this.latestOutput.size() != 1 || !this.openFile(this.latestOutput.get(0))) {
                this.openFile(this.destination);
            }
        });
        StaticStudio.eventStudio().add(TaskExecutionRequest.class, e -> {
            if (e.toolId().equals(ownerModule)) {
                this.latestOutput.clear();
                try {
                    if (!Objects.isNull(e.parameters().getOutput())) {
                        e.parameters().getOutput().accept((TaskOutputDispatcher)this);
                    }
                }
                catch (TaskOutputVisitException ex) {
                    LOG.warn("This should never happen", (Throwable)ex);
                }
            }
        }, -10, ReferenceStrength.STRONG);
        tools.forEach(m -> {
            if (m.descriptor().hasInputType(outputType)) {
                this.getItems().add((Object)new OpenWithMenuItem((Tool)m));
            }
        });
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    private boolean openFile(File file) {
        if (file != null && file.exists()) {
            StaticStudio.eventStudio().broadcast((Object)new NativeOpenFileRequest(file));
            return true;
        }
        return false;
    }

    @EventStation
    public String getOwnerModule() {
        return this.ownerModule;
    }

    @EventListener(priority=-10)
    public void onTaskCompleted(TaskExecutionCompletedEvent event) {
        this.latestOutput.addAll(event.getNotifiableTaskMetadata().taskOutput());
    }

    public void dispatch(FileTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)FontIcon.of((Ikon)UniconsLine.FILE_ALT));
    }

    public void dispatch(DirectoryTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)FontIcon.of((Ikon)UniconsLine.FOLDER_OPEN));
    }

    public void dispatch(FileOrDirectoryTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)FontIcon.of((Ikon)UniconsLine.FOLDER_OPEN));
    }

    private class OpenWithMenuItem
    extends MenuItem {
        private OpenWithMenuItem(Tool tool) {
            this.setText(tool.descriptor().name());
            this.setOnAction(e -> {
                StaticStudio.eventStudio().broadcast((Object)new ClearToolRequest(tool.id(), false, false), tool.id());
                StaticStudio.eventStudio().broadcast((Object)new SetActiveContentItemRequest(tool.id()));
                PdfLoadRequest loadEvent = new PdfLoadRequest(tool.id());
                OpenButton.this.latestOutput.stream().map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequest)loadEvent).add(arg_0));
                StaticStudio.eventStudio().broadcast((Object)loadEvent, tool.id());
            });
        }
    }
}

