/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.tool;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.TaskExecutionRequest;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.ui.components.tool.OpenButton;
import org.pdfsam.ui.components.tool.RunButton;
import org.pdfsam.ui.components.tool.TaskFailedButton;
import org.sejda.model.notification.event.PercentageOfWorkDoneChangedEvent;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;

public class Footer
extends HBox
implements ToolBound {
    private final ProgressBar bar = new ProgressBar(0.0);
    private final Label statusLabel = new Label();
    private final TaskFailedButton failed = new TaskFailedButton();
    private final OpenButton openButton;
    private final RunButton runButton;
    private String ownerModule;

    public Footer(RunButton runButton, OpenButton openButton, String ownerModule) {
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
        this.openButton = openButton;
        this.runButton = runButton;
        this.getStyleClass().addAll((Object[])new String[]{"footer-pane"});
        this.statusLabel.getStyleClass().add((Object)"status-label");
        this.statusLabel.setVisible(false);
        this.bar.setMaxWidth(Double.MAX_VALUE);
        this.bar.getStyleClass().add((Object)"pdfsam-footer-bar");
        this.statusLabel.setMaxHeight(Double.MAX_VALUE);
        VBox progressPane = new VBox(new Node[]{this.statusLabel, this.bar});
        progressPane.getStyleClass().add((Object)"progress-pane");
        VBox.setVgrow((Node)this.statusLabel, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.bar, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)progressPane, (Priority)Priority.ALWAYS);
        this.failed.setVisible(false);
        StackPane buttons = new StackPane(new Node[]{this.failed, openButton});
        buttons.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().addAll((Object[])new Node[]{runButton, buttons, progressPane});
        StaticStudio.eventStudio().add(TaskExecutionRequest.class, e -> {
            if (e.toolId().equals(ownerModule)) {
                this.failed.setVisible(false);
                openButton.setVisible(false);
                this.statusLabel.setVisible(true);
                this.statusLabel.setText(I18nContext.i18n().tr("Requested"));
                this.bar.setProgress(0.0);
            }
        });
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public OpenButton openButton() {
        return this.openButton;
    }

    public RunButton runButton() {
        return this.runButton;
    }

    @EventStation
    public String toolBinding() {
        return this.ownerModule;
    }

    @EventListener
    public void onTaskCompleted(TaskExecutionCompletedEvent event) {
        this.failed.setVisible(false);
        this.openButton.setVisible(true);
        this.statusLabel.setText(I18nContext.i18n().tr("Completed"));
        this.bar.setProgress(1.0);
    }

    @EventListener
    public void onTaskFailed(TaskExecutionFailedEvent event) {
        this.openButton.setVisible(false);
        this.failed.setVisible(true);
        this.statusLabel.setText(I18nContext.i18n().tr("Failed"));
    }

    @EventListener
    public void onProgress(PercentageOfWorkDoneChangedEvent event) {
        this.statusLabel.setText(I18nContext.i18n().tr("Running"));
        if (event.isUndetermined()) {
            this.bar.setProgress(-1.0);
        } else {
            this.bar.setProgress(event.getPercentage().divide(new BigDecimal(100), RoundingMode.HALF_UP).doubleValue());
            this.statusLabel.setText(I18nContext.i18n().tr("Running {0}%", new String[]{Integer.toString(event.getPercentage().intValue())}));
        }
    }
}

