/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.support;

import java.util.Collection;
import java.util.LinkedList;
import javafx.collections.ModifiableObservableListBase;
import org.sejda.commons.util.RequireUtils;

public class CircularObservableList<E>
extends ModifiableObservableListBase<E> {
    private final LinkedList<E> wrapped = new LinkedList();
    private int maxCapacity;

    public CircularObservableList(int maxCapacity) {
        this.setMaxCapacity(maxCapacity);
    }

    public void setMaxCapacity(int maxCapacity) {
        RequireUtils.requireArg((maxCapacity > 0 ? 1 : 0) != 0, (String)"Max capacity must be a positive value");
        this.maxCapacity = maxCapacity;
        this.houseKeep();
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    private void houseKeep() {
        while (this.size() > this.maxCapacity) {
            this.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean retVal;
        try {
            this.beginChange();
            retVal = this.wrapped.addAll(index, c);
            this.nextAdd(index, index + c.size());
            this.houseKeep();
            ++this.modCount;
        }
        finally {
            this.endChange();
        }
        return retVal;
    }

    public E get(int index) {
        return this.wrapped.get(index);
    }

    public int size() {
        return this.wrapped.size();
    }

    protected void doAdd(int index, E element) {
        this.wrapped.add(index, element);
        this.houseKeep();
    }

    protected E doSet(int index, E element) {
        return this.wrapped.set(index, element);
    }

    protected E doRemove(int index) {
        return this.wrapped.remove(index);
    }
}

