/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.selection.multiple;

import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.ui.components.selection.multiple.SelectionTableColumn;
import org.pdfsam.ui.components.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.components.selection.multiple.TooltippedTableCell;

public enum IntColumn implements SelectionTableColumn<Integer>
{
    PAGES{

        @Override
        public String getColumnTitle() {
            return I18nContext.i18n().tr("Pages");
        }

        @Override
        public ObservableValue<Integer> getObservableValue(SelectionTableRowData data) {
            return data.descriptor().pages();
        }

        @Override
        public String getTextValue(Integer item) {
            if (item != null && item > 0) {
                return item.toString();
            }
            return "";
        }

        @Override
        public Comparator<Integer> comparator() {
            return Comparator.naturalOrder();
        }

        @Override
        public Float prefWidth() {
            return Float.valueOf(50.0f);
        }

        @Override
        public Callback<TableColumn<SelectionTableRowData, Integer>, TableCell<SelectionTableRowData, Integer>> cellFactory() {
            return param -> new TooltippedTableCell<Integer>(I18nContext.i18n().tr("Number of total pages of the document")){

                @Override
                void onUpdateItem(Integer item, boolean empty) {
                    if (empty || item == null) {
                        this.setText("");
                    } else {
                        this.setText(this.getTextValue(item));
                    }
                }
            };
        }
    };

}

