/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.BooleanPersistentProperty;
import org.pdfsam.core.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ToolBound;
import org.pdfsam.model.ui.DefaultPdfVersionComboItem;
import org.pdfsam.model.ui.PdfVersionComboItem;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.SetDestinationRequest;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.ui.components.io.BrowsableField;
import org.pdfsam.ui.components.io.DestinationPane;
import org.pdfsam.ui.components.io.PdfVersionCombo;
import org.pdfsam.ui.components.io.PdfVersionConstrainedCheckBox;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.pdf.PdfVersion;

public class PdfDestinationPane
extends DestinationPane
implements ToolBound,
RestorableView,
ResettableView,
TaskParametersBuildStep<AbstractPdfOutputParametersBuilder<? extends AbstractPdfOutputParameters>> {
    private final PdfVersionCombo version;
    private final PdfVersionConstrainedCheckBox compress;
    private Optional<CheckBox> discardBookmarks = Optional.empty();
    private final String toolBinding;

    public PdfDestinationPane(BrowsableField destination, String toolBinding, DestinationPanelFields ... optionalFields) {
        this(destination, toolBinding, false, optionalFields);
    }

    public PdfDestinationPane(BrowsableField destination, String toolBinding, boolean expandAdvanced, DestinationPanelFields ... optionalFields) {
        super(destination);
        destination.setId(toolBinding + ".destination");
        this.overwrite().setSelected(ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.OVERWRITE_OUTPUT));
        this.toolBinding = StringUtils.defaultString((String)toolBinding);
        VBox advancedPanel = new VBox();
        advancedPanel.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.version = new PdfVersionCombo(toolBinding);
        this.compress = new PdfVersionConstrainedCheckBox(PdfVersion.VERSION_1_5, toolBinding);
        this.compress.setText(I18nContext.i18n().tr("Compress output file/files"));
        this.compress.setSelected(ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.PDF_COMPRESSION_ENABLED));
        this.compress.setId("compressField");
        this.compress.getStyleClass().addAll((Object[])Style.VITEM.css());
        if (Arrays.asList(optionalFields).contains((Object)DestinationPanelFields.DISCARD_BOOKMARKS)) {
            CheckBox discardBookmarksField = new CheckBox(I18nContext.i18n().tr("Discard bookmarks"));
            discardBookmarksField.setGraphic((Node)Views.helpIcon(I18nContext.i18n().tr("Tick the box if you don't want to retain any bookmark from the original PDF document")));
            discardBookmarksField.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
            discardBookmarksField.getStyleClass().addAll((Object[])Style.VITEM.css());
            discardBookmarksField.setId("discardBookmarksField");
            discardBookmarksField.setSelected(ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.DISCARD_BOOKMARKS));
            this.discardBookmarks = Optional.of(discardBookmarksField);
        }
        HBox versionPane = new HBox(new Node[]{new Label(I18nContext.i18n().tr("Output PDF version:")), this.version});
        versionPane.getStyleClass().addAll((Object[])Style.VITEM.css());
        versionPane.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        advancedPanel.getChildren().add((Object)this.compress);
        this.discardBookmarks.ifPresent(arg_0 -> advancedPanel.getChildren().add(arg_0));
        advancedPanel.getChildren().add((Object)versionPane);
        TitledPane titledAdvanced = Views.titledPane(I18nContext.i18n().tr("Show advanced settings"), (Node)advancedPanel, "advanced-destination-pane");
        titledAdvanced.setExpanded(expandAdvanced);
        titledAdvanced.expandedProperty().addListener((o, oldval, newVal) -> {
            if (newVal.booleanValue()) {
                titledAdvanced.setText(I18nContext.i18n().tr("Hide advanced settings"));
            } else {
                titledAdvanced.setText(I18nContext.i18n().tr("Show advanced settings"));
            }
        });
        this.getChildren().add((Object)titledAdvanced);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public void enableSameAsSourceItem() {
        this.version.enableSameAsSourceItem();
    }

    @EventStation
    public String toolBinding() {
        return this.toolBinding;
    }

    @EventListener
    public void setDestination(SetDestinationRequest event) {
        if (!event.fallback() || StringUtils.isBlank((CharSequence)this.destination().getTextField().getText()) && ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.SMART_OUTPUT)) {
            this.destination().setTextFromFile(event.footprint());
        }
    }

    @Override
    public void resetView() {
        super.resetView();
        this.version.resetView();
        this.compress.setSelected(false);
        this.compress.setSelected(ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.PDF_COMPRESSION_ENABLED));
        this.overwrite().setSelected(ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.OVERWRITE_OUTPUT));
        this.discardBookmarks.ifPresent(c -> c.setSelected(ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.DISCARD_BOOKMARKS)));
    }

    public void apply(AbstractPdfOutputParametersBuilder<? extends AbstractPdfOutputParameters> builder, Consumer<String> onError) {
        builder.compress(this.compress.isSelected());
        if (this.overwrite().isSelected()) {
            builder.existingOutput(ExistingOutputPolicy.OVERWRITE);
        }
        builder.version(((PdfVersionComboItem)this.version.getSelectionModel().getSelectedItem()).getVersion());
        this.discardBookmarks.ifPresent(d -> builder.discardBookmarks(d.isSelected()));
    }

    public void saveStateTo(Map<String, String> data) {
        data.put("compress", Boolean.toString(this.compress.isSelected()));
        data.put("overwrite", Boolean.toString(this.overwrite().isSelected()));
        this.discardBookmarks.ifPresent(d -> data.put("discardBookmarks", Boolean.toString(d.isSelected())));
        data.put("version", ((PdfVersionComboItem)this.version.getSelectionModel().getSelectedItem()).getVersion().toString());
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.version.resetView();
        this.compress.setSelected(Boolean.parseBoolean(data.get("compress")));
        this.overwrite().setSelected(Boolean.parseBoolean(data.get("overwrite")));
        this.discardBookmarks.ifPresent(d -> d.setSelected(Boolean.parseBoolean((String)data.get("discardBookmarks"))));
        Optional.ofNullable(data.get("version")).map(PdfVersion::valueOf).map(DefaultPdfVersionComboItem::new).ifPresent(v -> this.version.getSelectionModel().select(v));
    }

    PdfVersionCombo getVersion() {
        return this.version;
    }

    PdfVersionConstrainedCheckBox getCompress() {
        return this.compress;
    }

    public static enum DestinationPanelFields {
        DISCARD_BOOKMARKS;

    }
}

