/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.VBox;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.ui.components.io.BrowsableField;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;
import org.sejda.commons.util.RequireUtils;

class DestinationPane
extends VBox
implements ResettableView {
    private final CheckBox overwrite = new CheckBox(I18nContext.i18n().tr("Overwrite if already exists"));
    private final BrowsableField destination;

    public DestinationPane(BrowsableField destination) {
        super(5.0);
        RequireUtils.requireNotNullArg((Object)((Object)destination), (String)"Destination field cannot be null");
        this.destination = destination;
        this.overwrite.setSelected(false);
        this.overwrite.setGraphic((Node)Views.helpIcon(I18nContext.i18n().tr("Tick the box if you want to overwrite the output files if they already exist.")));
        this.overwrite.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        this.getChildren().addAll((Object[])new Node[]{destination, this.overwrite});
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.VCONTAINER.css());
    }

    protected CheckBox overwrite() {
        return this.overwrite;
    }

    protected BrowsableField destination() {
        return this.destination;
    }

    public void resetView() {
        this.overwrite.setSelected(false);
        this.destination.getTextField().setText("");
    }
}

