/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.io.Choosers;
import org.pdfsam.core.io.FileChooserWithWorkingDirectory;
import org.pdfsam.core.support.validation.Validator;
import org.pdfsam.core.support.validation.Validators;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.io.FileType;
import org.pdfsam.model.io.OpenType;
import org.pdfsam.ui.components.io.BrowsableField;

public class BrowsableFileField
extends BrowsableField {
    private FileType fileType = FileType.ALL;
    private OpenType openType = OpenType.OPEN;
    private final BrowseEventHandler handler = new BrowseEventHandler();

    public BrowsableFileField(FileType fileType, OpenType openType) {
        this.init(fileType, openType);
    }

    public BrowsableFileField(FileType fileType, OpenType openType, Button browseButton) {
        super(browseButton);
        this.init(fileType, openType);
    }

    private void init(FileType fileType, OpenType openType) {
        this.setBrowseWindowTitle(I18nContext.i18n().tr("Select a file"));
        this.getBrowseButton().setOnAction((EventHandler)this.handler);
        this.getTextField().setOnAction(this.handler);
        this.fileType = (FileType)ObjectUtils.defaultIfNull((Object)fileType, (Object)FileType.ALL);
        this.openType = (OpenType)ObjectUtils.defaultIfNull((Object)openType, (Object)OpenType.OPEN);
        if (FileType.ALL != fileType) {
            this.getTextField().setPromptText(String.format("%s: %s", I18nContext.i18n().tr("Select a file"), fileType.getFilter().getExtensions()));
        } else {
            this.getTextField().setPromptText(I18nContext.i18n().tr("Select a file"));
        }
        this.setOnDragOver(e -> this.dragConsume((DragEvent)e, this.onDragOverConsumer()));
        this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped()));
    }

    public void enforceValidation(boolean selectedFileMustExists, boolean allowEmptyString) {
        Validator validator = Validators.fileType((FileType)this.fileType, (boolean)selectedFileMustExists);
        if (allowEmptyString) {
            validator = Validators.validEmpty((Validator)validator);
        }
        this.getTextField().setValidator((Validator<String>)validator);
        this.getTextField().setErrorMessage(this.buildErrorMessage(selectedFileMustExists));
    }

    private String buildErrorMessage(boolean selectedFileMustExists) {
        Object errorMessage;
        Object object = errorMessage = selectedFileMustExists ? I18nContext.i18n().tr("The selected file must exist. ") : "";
        if (FileType.ALL != this.fileType) {
            errorMessage = (String)errorMessage + I18nContext.i18n().tr("Allowed extensions are {0}", new String[]{this.fileType.getFilter().getDescription()});
        }
        return StringUtils.trim((String)errorMessage);
    }

    @Override
    public void setTextFromFile(File inputFile) {
        if (inputFile != null) {
            this.getTextField().setText(inputFile.getAbsolutePath());
            this.getTextField().validate();
        }
    }

    private void dragConsume(DragEvent e, Consumer<DragEvent> c) {
        if (e.getDragboard().hasFiles()) {
            c.accept(e);
        }
        e.consume();
    }

    private Consumer<DragEvent> onDragOverConsumer() {
        return e -> e.acceptTransferModes(TransferMode.COPY_OR_MOVE);
    }

    private Consumer<DragEvent> onDragDropped() {
        return e -> {
            e.getDragboard().getFiles().stream().filter(f -> this.fileType.matches(f.getName())).findFirst().ifPresent(this::setTextFromFile);
            e.setDropCompleted(true);
        };
    }

    private class BrowseEventHandler
    implements EventHandler<ActionEvent> {
        private BrowseEventHandler() {
        }

        public void handle(ActionEvent event) {
            FileChooserWithWorkingDirectory fileChooser = Choosers.fileChooser((String)BrowsableFileField.this.getBrowseWindowTitle(), (FileType[])new FileType[]{BrowsableFileField.this.fileType});
            String currentSelection = BrowsableFileField.this.getTextField().getText();
            if (StringUtils.isNotBlank((CharSequence)currentSelection)) {
                Path path = Paths.get(currentSelection, new String[0]);
                if (!path.isAbsolute()) {
                    path = ApplicationContext.app().runtimeState().workingPathValue().map(w -> w.resolve(currentSelection)).orElse(path);
                }
                if (Files.exists(path, new LinkOption[0])) {
                    fileChooser.setInitialDirectory(path.getParent());
                    fileChooser.setInitialFileName(path.getFileName().toString());
                }
            }
            switch (BrowsableFileField.this.openType) {
                case SAVE: {
                    BrowsableFileField.this.setTextFromFile(fileChooser.showSaveDialog(BrowsableFileField.this.getTextField().getScene().getWindow()));
                    break;
                }
                case OPEN: {
                    BrowsableFileField.this.setTextFromFile(fileChooser.showOpenSingleDialog(BrowsableFileField.this.getTextField().getScene().getWindow()));
                }
            }
        }
    }
}

