/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.Clipboard;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.ui.components.commons.ValidableTextField;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.pdfsam.ui.components.support.Style;

abstract class BrowsableField
extends HBox
implements RestorableView {
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
    private final Button browseButton;
    private final ValidableTextField textField = new ValidableTextField(this){

        public void paste() {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            if (clipboard.hasString()) {
                String text = clipboard.getString();
                if (text.length() > 2 && text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
                    this.replaceSelection(text.substring(1, text.length() - 1));
                } else {
                    super.paste();
                }
            }
        }
    };
    private final HBox validableContainer;
    private String browseWindowTitle = I18nContext.i18n().tr("Select");

    public BrowsableField() {
        this(new Button(I18nContext.i18n().tr("Browse")));
        this.browseButton.getStyleClass().addAll((Object[])Style.BROWSE_BUTTON.css());
        this.browseButton.prefHeightProperty().bind((ObservableValue)this.textField.heightProperty());
        this.browseButton.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.browseButton.setMinHeight(Double.NEGATIVE_INFINITY);
        this.getChildren().add((Object)this.browseButton);
    }

    public BrowsableField(Button browseButton) {
        this.browseButton = browseButton;
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.getStyleClass().add((Object)"browsable-field");
        this.validableContainer = new HBox(new Node[]{this.textField});
        this.validableContainer.getStyleClass().add((Object)"validable-container");
        this.textField.getStyleClass().add((Object)"validable-container-field");
        HBox.setHgrow((Node)this.validableContainer, (Priority)Priority.ALWAYS);
        this.textField.validProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == FXValidationSupport.ValidationState.INVALID) {
                this.validableContainer.getStyleClass().addAll((Object[])Style.INVALID.css());
            } else {
                this.validableContainer.getStyleClass().removeAll((Object[])Style.INVALID.css());
            }
        });
        this.textField.focusedProperty().addListener((o, oldVal, newVal) -> this.validableContainer.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, newVal.booleanValue()));
        this.getChildren().add((Object)this.validableContainer);
    }

    public ValidableTextField getTextField() {
        return this.textField;
    }

    public void saveStateTo(Map<String, String> data) {
        data.put(StringUtils.defaultString((String)this.getId()) + "browsableField", StringUtils.defaultString((String)this.textField.getText()));
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.textField.setText(Optional.ofNullable(data.get(StringUtils.defaultString((String)this.getId()) + "browsableField")).orElse(""));
    }

    public final void setGraphic(Node value) {
        this.validableContainer.getChildren().clear();
        if (value != null) {
            this.validableContainer.getChildren().add((Object)value);
        }
        this.validableContainer.getChildren().add((Object)this.textField);
    }

    Button getBrowseButton() {
        return this.browseButton;
    }

    String getBrowseWindowTitle() {
        return this.browseWindowTitle;
    }

    public void setBrowseWindowTitle(String browseWindowTitle) {
        this.browseWindowTitle = browseWindowTitle;
    }

    abstract void setTextFromFile(File var1);

    public void setTextFromFile(Path inputFile) {
        if (Objects.nonNull(inputFile)) {
            this.setTextFromFile(inputFile.toFile());
        }
    }
}

