/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.io.Choosers;
import org.pdfsam.core.io.DirectoryChooserWithWorkingDirectory;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.ui.components.io.BrowsableField;

public class BrowsableDirectoryField
extends BrowsableField {
    public BrowsableDirectoryField() {
        this.setBrowseWindowTitle(I18nContext.i18n().tr("Select a directory"));
        this.getTextField().setErrorMessage(I18nContext.i18n().tr("Select an existing directory"));
        this.getTextField().setPromptText(I18nContext.i18n().tr("Select a directory"));
        BrowseEventHandler handler = new BrowseEventHandler();
        this.getBrowseButton().setOnAction((EventHandler)handler);
        this.getTextField().setOnAction(handler);
        this.setOnDragOver(e -> this.dragConsume((DragEvent)e, this.onDragOverConsumer()));
        this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped()));
    }

    @Override
    void setTextFromFile(File inputFile) {
        if (Objects.nonNull(inputFile)) {
            if (inputFile.isDirectory()) {
                this.getTextField().setText(inputFile.getAbsolutePath());
            } else {
                this.getTextField().setText(inputFile.getParent());
            }
            this.getTextField().validate();
        }
    }

    private void dragConsume(DragEvent e, Consumer<DragEvent> c) {
        List files = e.getDragboard().getFiles();
        if (files != null && !files.isEmpty()) {
            c.accept(e);
        }
        e.consume();
    }

    private Consumer<DragEvent> onDragOverConsumer() {
        return e -> e.acceptTransferModes(TransferMode.COPY_OR_MOVE);
    }

    private Consumer<DragEvent> onDragDropped() {
        return e -> {
            e.getDragboard().getFiles().stream().filter(File::isDirectory).findFirst().ifPresent(this::setTextFromFile);
            e.setDropCompleted(true);
        };
    }

    private class BrowseEventHandler
    implements EventHandler<ActionEvent> {
        private BrowseEventHandler() {
        }

        public void handle(ActionEvent event) {
            DirectoryChooserWithWorkingDirectory directoryChooser = Choosers.directoryChooser((String)BrowsableDirectoryField.this.getBrowseWindowTitle());
            String currentSelection = BrowsableDirectoryField.this.getTextField().getText();
            if (StringUtils.isNotBlank((CharSequence)currentSelection)) {
                Path path = Paths.get(currentSelection, new String[0]);
                if (!path.isAbsolute()) {
                    path = ApplicationContext.app().runtimeState().workingPathValue().map(w -> w.resolve(currentSelection)).orElse(path);
                }
                if (Files.exists(path, new LinkOption[0])) {
                    directoryChooser.setInitialDirectory(path);
                }
            }
            BrowsableDirectoryField.this.setTextFromFile(directoryChooser.showDialog(BrowsableDirectoryField.this.getTextField().getScene().getWindow()));
        }
    }
}

