/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.components.commons;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.Window;
import javafx.util.Duration;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.validation.Validator;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.pdfsam.ui.components.support.Style;
import org.sejda.commons.util.RequireUtils;

public class ValidableTextField
extends TextField {
    private static final KeyCombination ENTER_COMBO = new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[0]);
    private final FXValidationSupport<String> validationSupport = new FXValidationSupport();
    private ErrorTooltipManager errorTooltipManager;

    public ValidableTextField() {
        this("");
    }

    public ValidableTextField(String text) {
        super(text);
        this.getStyleClass().add((Object)"validable-field");
        this.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (!newVal.booleanValue()) {
                this.validate();
            }
        });
        this.textProperty().addListener((o, oldVal, newVal) -> this.validationSupport.makeNotValidated());
        this.validationSupport.validationStateProperty().addListener(o -> {
            if (this.validationSupport.validationStateProperty().get() == FXValidationSupport.ValidationState.INVALID && this.errorTooltipManager != null) {
                this.errorTooltipManager.showTooltip();
            }
        });
    }

    public final FXValidationSupport.ValidationState getValidationState() {
        return (FXValidationSupport.ValidationState)((Object)this.validationSupport.validationStateProperty().get());
    }

    public final ReadOnlyObjectProperty<FXValidationSupport.ValidationState> validProperty() {
        return this.validationSupport.validationStateProperty();
    }

    public void setEnableInvalidStyle(boolean active) {
        this.validationSupport.validationStateProperty().addListener(o -> {
            if (active) {
                if (this.validationSupport.validationStateProperty().get() == FXValidationSupport.ValidationState.INVALID) {
                    this.getStyleClass().addAll((Object[])Style.INVALID.css());
                } else {
                    this.getStyleClass().removeAll((Object[])Style.INVALID.css());
                }
            }
        });
    }

    public void setErrorMessage(String message) {
        this.errorTooltipManager = StringUtils.isNotBlank((CharSequence)message) ? new ErrorTooltipManager(message) : null;
    }

    public void setOnEnterValidation(boolean active) {
        this.setOnKeyReleased(t -> {
            if (active && ENTER_COMBO.match(t)) {
                this.validate();
            }
        });
    }

    public void setValidator(Validator<String> validator) {
        RequireUtils.requireNotNullArg(validator, (String)"Validator cannot be null for ValidableTextField");
        this.validationSupport.setValidator(validator);
    }

    public void validate() {
        this.validationSupport.validate(this.getText());
    }

    private final class ErrorTooltipManager {
        private static final String ERROR_TOOLTIP_CLASS = "error-tooltip";
        private final Tooltip tooltip;
        private boolean active = false;
        private final Timeline activationTimer = new Timeline();
        private final Timeline hideTimer = new Timeline();

        private ErrorTooltipManager(String message) {
            RequireUtils.requireNotBlank((String)message, (String)"Tooltip message cannot be blank");
            this.tooltip = new Tooltip(message);
            this.tooltip.getStyleClass().add((Object)ERROR_TOOLTIP_CLASS);
            this.hideTimer.getKeyFrames().add((Object)new KeyFrame(new Duration(5000.0), new KeyValue[0]));
            this.hideTimer.setOnFinished(e -> {
                this.tooltip.hide();
                this.active = false;
            });
            this.activationTimer.getKeyFrames().add((Object)new KeyFrame(new Duration(250.0), new KeyValue[0]));
            this.activationTimer.setOnFinished(e -> {
                Window owner;
                Scene scene;
                if (!this.active && (scene = ValidableTextField.this.getScene()) != null && (owner = scene.getWindow()) != null && owner.isShowing() && ValidableTextField.this.isVisible()) {
                    Point2D where = this.getDisplayCoordiantes(owner, scene);
                    this.tooltip.show((Node)ValidableTextField.this, where.getX(), where.getY());
                    this.active = true;
                    this.hideTimer.playFromStart();
                }
            });
        }

        private void showTooltip() {
            if (this.activationTimer.getStatus() != Animation.Status.RUNNING) {
                this.activationTimer.stop();
                this.activationTimer.playFromStart();
            }
        }

        private Point2D getDisplayCoordiantes(Window owner, Scene scene) {
            Point2D nodeCoord = ValidableTextField.this.localToScene(0.0, ValidableTextField.this.getHeight());
            double anchorX = Math.round(owner.getX() + scene.getX() + nodeCoord.getX());
            double anchorY = Math.round(owner.getY() + scene.getY() + nodeCoord.getY() + 1.0);
            return new Point2D(anchorX, anchorY);
        }
    }
}

