/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.extract;

import jakarta.inject.Named;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.injector.Provides;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.tool.ToolCategory;
import org.pdfsam.model.tool.ToolDescriptor;
import org.pdfsam.model.tool.ToolDescriptorBuilder;
import org.pdfsam.model.tool.ToolInputOutputType;
import org.pdfsam.model.tool.ToolPriority;
import org.pdfsam.persistence.PreferencesRepository;
import org.pdfsam.tools.extract.ExtractToolPanel;
import org.pdfsam.ui.components.io.BrowsableField;
import org.pdfsam.ui.components.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.prefix.PrefixPane;
import org.pdfsam.ui.components.tool.Footer;
import org.pdfsam.ui.components.tool.OpenButton;
import org.pdfsam.ui.components.tool.RunButton;

@Auto
public class ExtractTool
implements Tool {
    static final String TOOL_ID = "extract";
    private final ToolDescriptor descriptor = ToolDescriptorBuilder.builder().category(ToolCategory.SPLIT).inputTypes(new ToolInputOutputType[]{ToolInputOutputType.MULTIPLE_PDF, ToolInputOutputType.SINGLE_PDF}).name(I18nContext.i18n().tr("Extract")).description(I18nContext.i18n().tr("Extract pages from PDF documents.")).priority(ToolPriority.DEFAULT.getPriority()).supportURL("https://pdfsam.org/pdf-extract-pages/").build();

    public ToolDescriptor descriptor() {
        return this.descriptor;
    }

    public Pane panel() {
        return (Pane)ApplicationContext.app().instance(ExtractToolPanel.class);
    }

    public String id() {
        return TOOL_ID;
    }

    public Node graphic() {
        FontIcon icon = new FontIcon((Ikon)UniconsLine.FILE_EXPORT);
        icon.getStyleClass().addAll((Object[])new String[]{this.descriptor().category().styleClass(), "tool-icon"});
        return icon;
    }

    public static class ModuleConfig {
        @Provides
        @Named(value="extractfield")
        public BrowsableOutputDirectoryField destinationDirectoryField() {
            return new BrowsableOutputDirectoryField();
        }

        @Provides
        @Named(value="extractpane")
        public PdfDestinationPane destinationPane(@Named(value="extractfield") BrowsableOutputDirectoryField outputField) {
            return new PdfDestinationPane((BrowsableField)outputField, ExtractTool.TOOL_ID, new PdfDestinationPane.DestinationPanelFields[]{PdfDestinationPane.DestinationPanelFields.DISCARD_BOOKMARKS});
        }

        @Provides
        @Named(value="extractfooter")
        public Footer footer(RunButton runButton, @Named(value="extractopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, ExtractTool.TOOL_ID);
        }

        @Provides
        @Named(value="extractopenButton")
        public OpenButton openButton() {
            return new OpenButton(ExtractTool.TOOL_ID, ToolInputOutputType.MULTIPLE_PDF);
        }

        @Provides
        @Named(value="extractprefix")
        public PrefixPane prefixPane() {
            return new PrefixPane(ExtractTool.TOOL_ID, new PreferencesRepository("/org/pdfsam/user/conf/extract"));
        }
    }
}

