/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.extract;

import java.util.Set;
import org.pdfsam.core.support.params.MultiplePdfSourceMultipleOutputParametersBuilder;
import org.sejda.model.optimization.OptimizationPolicy;
import org.sejda.model.parameter.ExtractPagesParameters;
import org.sejda.model.pdf.page.PagesSelection;

class ExtractParametersBuilder
extends MultiplePdfSourceMultipleOutputParametersBuilder<ExtractPagesParameters> {
    private OptimizationPolicy optimizationPolicy = OptimizationPolicy.AUTO;
    private Set<PagesSelection> pagesSelection;
    private boolean invertSelection = false;
    private boolean separateForEachRange = false;

    ExtractParametersBuilder() {
    }

    public void optimizationPolicy(OptimizationPolicy optimizationPolicy) {
        this.optimizationPolicy = optimizationPolicy;
    }

    public OptimizationPolicy getOptimizationPolicy() {
        if (!Boolean.getBoolean("org.pdfsam.disable.split.optimization")) {
            return this.optimizationPolicy;
        }
        return OptimizationPolicy.NO;
    }

    public void pagesSelection(Set<PagesSelection> pagesSelection) {
        this.pagesSelection = pagesSelection;
    }

    public void invertSelection(boolean invertSelection) {
        this.invertSelection = invertSelection;
    }

    public void separateForEachRange(boolean separateForEachRange) {
        this.separateForEachRange = separateForEachRange;
    }

    public ExtractPagesParameters build() {
        ExtractPagesParameters params = new ExtractPagesParameters();
        params.setCompress(this.isCompress());
        params.setExistingOutputPolicy(this.existingOutput());
        params.setVersion(this.getVersion());
        params.setOutput(this.getOutput());
        params.setOptimizationPolicy(this.getOptimizationPolicy());
        params.discardOutline(this.isDiscardBookmarks());
        this.pagesSelection.forEach(arg_0 -> ((ExtractPagesParameters)params).addPageRange(arg_0));
        params.setOutputPrefix(this.getPrefix());
        params.setInvertSelection(this.invertSelection);
        params.setSeparateFileForEachRange(this.separateForEachRange);
        this.getInputs().forEach(arg_0 -> ((ExtractPagesParameters)params).addSource(arg_0));
        return params;
    }
}

