/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.model.tool;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.model.tool.ToolCategory;
import org.pdfsam.model.tool.ToolInputOutputType;
import org.sejda.commons.util.RequireUtils;

public record ToolDescriptor(ToolCategory category, String name, String description, int priority, String supportUrl, List<ToolInputOutputType> inputTypes) {
    public ToolDescriptor(ToolCategory category, String name, String description, int priority, String supportUrl, List<ToolInputOutputType> inputTypes) {
        RequireUtils.requireNotBlank((String)name, (String)"Tool name cannot be blank");
        RequireUtils.requireNotBlank((String)description, (String)"Tool description cannot be blank");
        this.category = Objects.requireNonNull(category);
        this.name = name;
        this.description = description;
        this.priority = priority;
        this.supportUrl = (String)StringUtils.defaultIfBlank((CharSequence)supportUrl, null);
        this.inputTypes = Objects.requireNonNull(inputTypes);
    }

    ToolDescriptor(ToolCategory category, String name, String description, int priority, String supportUrl, ToolInputOutputType ... inputTypes) {
        this(category, name, description, priority, supportUrl, Optional.ofNullable(inputTypes).filter(t -> ((ToolInputOutputType[])t).length > 0).map(Arrays::asList).orElseGet(() -> List.of(ToolInputOutputType.OTHER)));
    }

    public boolean hasInputType(ToolInputOutputType type) {
        return this.inputTypes.contains((Object)type);
    }
}

