/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.model.pdf;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.i18n.I18nContext;

public enum PdfDescriptorLoadingStatus {
    INITIAL,
    REQUESTED((Ikon)UniconsLine.CLOCK, ""),
    LOADING((Ikon)UniconsLine.ANGLE_RIGHT, ""),
    LOADED,
    LOADED_WITH_USER_PWD_DECRYPTION((Ikon)UniconsLine.UNLOCK, I18nContext.i18n().tr("Valid user password provided.")),
    ENCRYPTED((Ikon)UniconsLine.LOCK, I18nContext.i18n().tr("This document is encrypted, click to provide a password."), "with-warnings"),
    WITH_ERRORS((Ikon)UniconsLine.EXCLAMATION_CIRCLE, I18nContext.i18n().tr("An error has occurred, click for more details."), "with-errors");

    private final Set<PdfDescriptorLoadingStatus> validNext = new HashSet<PdfDescriptorLoadingStatus>();
    private final Ikon icon;
    private final String description;
    private final String style;

    private PdfDescriptorLoadingStatus() {
        this(null, "");
    }

    private PdfDescriptorLoadingStatus(Ikon icon, String description) {
        this(icon, description, "");
    }

    private PdfDescriptorLoadingStatus(Ikon icon, String description, String style) {
        this.icon = icon;
        this.description = StringUtils.defaultString((String)description);
        this.style = StringUtils.defaultString((String)style);
    }

    public Ikon getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStyle() {
        return this.style;
    }

    private void setValidDestinationStatus(PdfDescriptorLoadingStatus ... canMoveTo) {
        this.validNext.addAll(Arrays.asList(canMoveTo));
    }

    public boolean canMoveTo(PdfDescriptorLoadingStatus dest) {
        return this.validNext.contains((Object)dest);
    }

    public PdfDescriptorLoadingStatus moveTo(PdfDescriptorLoadingStatus dest) {
        if (this.canMoveTo(dest)) {
            return dest;
        }
        throw new IllegalStateException("Cannot move status from " + String.valueOf((Object)this) + " to " + String.valueOf((Object)dest));
    }

    public boolean isFinal() {
        return this.validNext.isEmpty();
    }

    static {
        INITIAL.setValidDestinationStatus(REQUESTED, WITH_ERRORS);
        ENCRYPTED.setValidDestinationStatus(REQUESTED, WITH_ERRORS);
        LOADING.setValidDestinationStatus(LOADED, LOADED_WITH_USER_PWD_DECRYPTION, ENCRYPTED, WITH_ERRORS);
        REQUESTED.setValidDestinationStatus(LOADING, WITH_ERRORS);
    }
}

