/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.splitbybookmarks;

import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Consumer;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.tools.splitbybookmarks.BookmarksLevelComboBox;
import org.pdfsam.tools.splitbybookmarks.SplitByOutlineLevelParametersBuilder;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;

class SplitOptionsPane
extends GridPane
implements TaskParametersBuildStep<SplitByOutlineLevelParametersBuilder>,
RestorableView,
ResettableView {
    private final BookmarksLevelComboBox levelCombo = new BookmarksLevelComboBox();
    private final TextField regexpField = new TextField();

    SplitOptionsPane() {
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.GRID.css());
        this.levelCombo.setId("bookmarksLevel");
        this.regexpField.setId("bookmarksRegexp");
        this.regexpField.setPromptText(I18nContext.i18n().tr("Regular expression the bookmark has to match"));
        this.regexpField.setPrefWidth(350.0);
        Label label = new Label(I18nContext.i18n().tr("Split at this bookmark level:"));
        GridPane.setValignment((Node)label, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        this.add((Node)label, 0, 0);
        GridPane.setValignment((Node)this.levelCombo, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)this.levelCombo, (HPos)HPos.LEFT);
        this.add((Node)this.levelCombo, 1, 0, 2, 1);
        Label regexLabel = new Label(I18nContext.i18n().tr("Matching regular expression:"));
        GridPane.setValignment((Node)regexLabel, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)regexLabel, (HPos)HPos.LEFT);
        this.add((Node)regexLabel, 0, 1);
        GridPane.setValignment((Node)this.regexpField, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)this.regexpField, (HPos)HPos.LEFT);
        this.add((Node)this.regexpField, 1, 1);
        Text helpIcon = Views.helpIcon((String)"%s\n%s\n".formatted(I18nContext.i18n().tr("A regular expression the bookmark text has to match"), I18nContext.i18n().tr("Example: use .*Chapter.* to match bookmarks containing the word \"Chapter\"")));
        GridPane.setValignment((Node)helpIcon, (VPos)VPos.CENTER);
        GridPane.setHalignment((Node)helpIcon, (HPos)HPos.LEFT);
        this.add((Node)helpIcon, 2, 1);
    }

    void setValidBookmarkLevels(SortedSet<Integer> levels) {
        this.levelCombo.setValidBookmarkLevels(levels);
    }

    private HBox createLine(Node ... items) {
        HBox item = new HBox(items);
        item.getStyleClass().addAll((Object[])Style.VITEM.css());
        item.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        return item;
    }

    public void resetView() {
        this.regexpField.clear();
        this.levelCombo.resetView();
    }

    public void apply(SplitByOutlineLevelParametersBuilder builder, Consumer<String> onError) {
        this.levelCombo.apply(builder, onError);
        if (StringUtils.isNotBlank((CharSequence)this.regexpField.getText())) {
            builder.regexp(this.regexpField.getText());
        }
    }

    public void saveStateTo(Map<String, String> data) {
        data.put("regexp", StringUtils.defaultString((String)this.regexpField.getText()));
        this.levelCombo.saveStateTo(data);
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.regexpField.setText(Optional.ofNullable(data.get("regexp")).orElse(""));
        this.levelCombo.restoreStateFrom(data);
    }
}

