#!/bin/bash

# https://salsa.debian.org/java-team/libusb-java
# https://github.com/openjdk/jdk/search?q=filename%3Ajni.h
# https://github.com/libusb/libusb-compat-0.1/search?q=filename%3Ausb.h

# https://formulae.brew.sh/api/formula/libusb-compat.json
# curl -fsSL -H "Authorization: Bearer QQ==" "https://ghcr.io/..." > libusb-compat.gzip

# https://formulae.brew.sh/api/formula/libusb.json
# curl -fsSL -H "Authorization: Bearer QQ==" "https://ghcr.io/..." > libusb.gzip

set -e
shopt -s lastpipe
pushd "$(dirname "${BASH_SOURCE[0]}")"

raise () {
    # $1: message
    printf "Error: $1\n\n" >&2
    exit 1
}

match () {
    # $1:pattern, $2:optional group
    [[ "$(</dev/stdin)" =~ $1 ]] || exit 1
    echo ${BASH_REMATCH[$2]}
}


ARCH=$(uname -m)

case $ARCH in
    arm64)  BREW_HOME=/opt/homebrew ;;
    *)      BREW_HOME=/usr/local ;;
esac

pushd $ARCH
[[ -f libusb-0.1.4.dylib ]] || raise "$(pwd)/libusb-0.1.4.dylib is missing."
[[ -f libusb-1.0.0.dylib ]] || raise "$(pwd)/libusb-1.0.0.dylib is missing."


echo "Change linking in libusb-1.0.0.dylib ..."

FILE=libusb-1.0.0.dylib

codesign -dvvvv $FILE 2>&1 | match 'Authority' >/dev/null \
  && codesign --sign - --force $FILE

install_name_tool -id "@rpath/$FILE" $FILE

oTool -l $FILE | match "path @loader_path" >/dev/null \
  || install_name_tool -add_rpath "@loader_path" $FILE

oTool -l $FILE | grep "path \| name "


echo "Change linking in libusb-0.1.4.dylib ..."

FILE=libusb-0.1.4.dylib

codesign -dvvvv $FILE 2>&1 | match 'Authority' >/dev/null \
  && codesign --sign - --force $FILE

install_name_tool -id "@rpath/$FILE" $FILE

oTool -l $FILE | match "name ([^ ]+libusb-1.0.0.dylib)" 1 \
  | install_name_tool -change "$(</dev/stdin)" "@rpath/libusb-1.0.0.dylib" $FILE

oTool -l $FILE | match "path $BREW_HOME/opt/libusb/lib" >/dev/null \
  || install_name_tool -add_rpath "$BREW_HOME/opt/libusb/lib" $FILE

oTool -l $FILE | match "path @loader_path" >/dev/null \
  || install_name_tool -add_rpath "@loader_path" $FILE

oTool -l $FILE | grep "path \| name "


echo "Build libusbJava.dylib"

rm -f libusbJava.dylib

gcc -dynamiclib -fPIC -std=c99 -Wall\
 -I ..\
 -Wl,-rpath,$BREW_HOME/opt/libusb-compat/lib\
 -Wl,-rpath,@loader_path\
 -install_name "@rpath/libusbJava.dylib"\
 -current_version 0.2.4\
 -compatibility_version 0.2.4\
 -o libusbJava.dylib\
 ../LibusbJava.c\
 libusb-0.1.4.dylib

oTool -L libusbJava.dylib | grep 'path \| name '

popd
popd
echo "DONE !"
