/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;

public class Gsons {
    public static <T> T load(File file, Class<T> clazz) {
        if (file == null || !file.exists()) {
            return null;
        }
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
        Gson gson = new GsonBuilder().create();
        return gson.fromJson((Reader)inputStreamReader, clazz);
    }

    public static <T> void persist(File file, T t) {
        if (t == null) {
            return;
        }
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8"));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(t, (Appendable)outputStreamWriter);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (JsonIOException jsonIOException) {
            jsonIOException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

