/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.ui.tune;

import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import com.owon.uppersoft.vds.ui.prompt.FadeIOShell;
import com.owon.uppersoft.vds.util.MyFileFilter;
import com.owon.vds.tiny.firm.pref.model.Register;
import com.owon.vds.tiny.firm.pref.model.TuneTexter;
import com.owon.vds.tiny.tune.TinyTuneDelegate;
import com.owon.vds.tiny.tune.TinyTuneFunction;
import com.owon.vds.tiny.ui.tune.ArgTypePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;

public class TinyTuneDialog {
    private JDialog frame;
    private TinyTuneFunction tf;
    private Register reg;
    private ByteBuffer calibration = ByteBuffer.wrap(new byte[1000]);
    private boolean save;
    private JTabbedPane jtp;

    public TinyTuneDialog(TinyTuneFunction tinyTuneFunction, Window window) {
        this.tf = tinyTuneFunction;
        this.reg = tinyTuneFunction.getTuneModel().getRegister();
        this.calibration.position(0);
        tinyTuneFunction.getTuneModel().writeArgsAtPartitionBuffer(this.calibration);
        this.initialize(window);
    }

    public ArgTypePane getCurrentArgTypePane() {
        Component component = this.jtp.getSelectedComponent();
        if (component == null || !(component instanceof ArgTypePane)) {
            return null;
        }
        return (ArgTypePane)component;
    }

    public void contentUpdateWithoutSync() {
        Component[] componentArray;
        for (Component component : componentArray = this.jtp.getComponents()) {
            if (component == null || !(component instanceof ArgTypePane)) continue;
            ArgTypePane argTypePane = (ArgTypePane)component;
            argTypePane.contentUpdate();
        }
    }

    private void initialize(Window window) {
        this.frame = new JDialog(window);
        this.frame.setTitle(I18nProvider.bundle().getString("M.Utility.Tune"));
        this.frame.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new OneColumnLayout());
        this.frame.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(0, 180));
        jPanel2.setLayout(new BorderLayout());
        jPanel.add(jPanel2);
        this.jtp = this.tf.createTabs(jPanel2);
        this.createBottom(jPanel);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                TinyTuneDialog.this.onClose();
            }
        });
        this.frame.pack();
        this.frame.setLocationRelativeTo(window);
        this.frame.setVisible(true);
    }

    private void onClose() {
        if (this.save) {
            this.tf.getDefaultPrefControl().save2DevicePart();
        } else {
            this.calibration.position(0);
            this.tf.getTuneModel().readArgsFromPartitionBuffer(this.calibration);
            this.contentUpdateWithoutSync();
            ArgTypePane argTypePane = this.getCurrentArgTypePane();
            if (argTypePane != null) {
                argTypePane.sync2Device();
            }
        }
        this.tf.release();
    }

    protected void createBottom(Container container) {
        ResourceBundle resourceBundle = I18nProvider.bundle();
        final TinyTuneDelegate tinyTuneDelegate = this.tf.getTinyTuneDelegate();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new OneColumnLayout());
        container.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel.add(jPanel2);
        jPanel.add(new JSeparator());
        jPanel.add(jPanel3);
        this.createBtn(resourceBundle.getString("Internal.loadtxt"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TinyTuneDialog.this.fileChooseForLoad()) {
                    return;
                }
                TinyTuneDialog.this.contentUpdateWithoutSync();
                ArgTypePane argTypePane = TinyTuneDialog.this.getCurrentArgTypePane();
                if (argTypePane != null) {
                    argTypePane.sync2Device();
                }
            }
        }, jPanel2, 140);
        this.createBtn(resourceBundle.getString("Internal.SaveTxt"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TinyTuneDialog.this.fileChooseForSave();
            }
        }, jPanel2, 140);
        this.createBtn(resourceBundle.getString("Action.Default"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                tinyTuneDelegate.resumeFactoryNSync();
                TinyTuneDialog.this.contentUpdateWithoutSync();
            }
        }, jPanel2, 140);
        this.createBtn(resourceBundle.getString("Internal.Calibration"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TinyTuneDialog.this.frame.dispose();
                TinyTuneDialog.this.tf.doselfcorrect();
            }
        }, jPanel2, 140);
        this.createBtn(resourceBundle.getString("Option.Cancel"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TinyTuneDialog.this.frame.dispose();
            }
        }, jPanel3, 140);
        this.createBtn(resourceBundle.getString("Option.OK"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TinyTuneDialog.this.save = true;
                TinyTuneDialog.this.frame.dispose();
            }
        }, jPanel3, 140);
    }

    protected boolean fileChooseForLoad() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setPreferredSize(new Dimension(500, 500));
        jFileChooser.setCurrentDirectory(new File(TuneTexter.SETTINGS_DIR));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(MyFileFilter.TxtFilter);
        jFileChooser.setFileFilter(MyFileFilter.TxtFilter);
        int n = jFileChooser.showOpenDialog(this.frame);
        if (n != 0) {
            return false;
        }
        String string = jFileChooser.getSelectedFile().getPath();
        if (this.tf.createTuneTexter().resetup(new File(string))) {
            return true;
        }
        FadeIOShell fadeIOShell = new FadeIOShell();
        fadeIOShell.prompt("Cannot load txt", this.frame);
        return false;
    }

    protected void fileChooseForSave() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setPreferredSize(new Dimension(500, 500));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(MyFileFilter.TxtFilter);
        jFileChooser.setFileFilter(MyFileFilter.TxtFilter);
        File file = new File(TuneTexter.SETTINGS_DIR, "device-settings");
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(this.frame);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            if (!file2.getPath().endsWith(".txt")) {
                file2 = new File(file2.getPath() + ".txt");
            }
            this.tf.createTuneTexter().save(file2);
        }
    }

    protected JButton createBtn(String string, ActionListener actionListener, Container container, int n) {
        JButton jButton = new JButton();
        jButton.setPreferredSize(new Dimension(n, 30));
        container.add(jButton);
        jButton.addActionListener(actionListener);
        jButton.setText(string);
        return jButton;
    }

    public void toFront() {
        this.frame.toFront();
    }
}

