/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.ui.tune;

import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.vds.core.tune.IntVolt;
import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import com.owon.uppersoft.vds.ui.widget.custom.CButton;
import com.owon.uppersoft.vds.util.ui.ComboboxMouseWheelSupport;
import com.owon.vds.tiny.firm.pref.model.ArgType;
import com.owon.vds.tiny.tune.TinyTuneDelegate;
import com.owon.vds.tiny.tune.detail.DefaultCalArgType;
import com.owon.vds.tiny.ui.tune.CompositeSpin;
import com.owon.vds.tiny.ui.tune.control.CalibrationArgType;
import com.owon.vds.tiny.ui.tune.widget.Listenable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ArgTypePane
extends JPanel
implements CalibrationArgType,
Listenable {
    protected DefaultCalArgType cmdt;
    protected TinyTuneDelegate ttd;
    private JComboBox vbcbb;
    protected CompositeSpin[] spinners;
    private boolean listening = false;

    public ArgTypePane(DefaultCalArgType defaultCalArgType, TinyTuneDelegate tinyTuneDelegate) {
        this.cmdt = defaultCalArgType;
        this.ttd = tinyTuneDelegate;
    }

    protected void setListening(boolean bl) {
        this.listening = bl;
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    public void contentUpdate(int n) {
        this.listening = false;
        this.vbcbb.setSelectedIndex(n);
        this.refreshContentWhileSuspend();
        this.listening = true;
    }

    @Override
    public void contentUpdate() {
        this.listening = false;
        this.refreshContentWhileSuspend();
        this.listening = true;
    }

    @Override
    public void onVoltbaseChange(int n, int n2) {
    }

    public void create(Container container, IntVolt[] intVoltArray) {
        int n = this.cmdt.channelNumber;
        this.spinners = new CompositeSpin[n];
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new OneColumnLayout(new Insets(35, 20, 10, 20), 2));
        this.vbcbb = this.createVBCBBForChannel(jPanel, n, intVoltArray);
        container.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(20, 20, 10));
        container.add((Component)jPanel2, "Center");
        for (int i = 0; i < n; ++i) {
            JPanel jPanel3 = new JPanel();
            FlowLayout flowLayout = new FlowLayout(4);
            jPanel3.setLayout(flowLayout);
            JLabel jLabel = new JLabel("CH" + (i + 1) + ":");
            jLabel.setPreferredSize(new Dimension(50, 28));
            jPanel3.add(jLabel);
            jPanel2.add(jPanel3);
            this.spinners[i] = this.createESpin(jPanel3, i, this.vbcbb);
        }
    }

    protected JComboBox createVBCBBForChannel(Container container, int n, IntVolt[] intVoltArray) {
        final JComboBox<IntVolt> jComboBox = new JComboBox<IntVolt>(intVoltArray);
        int n2 = Platform.getDataHouse().getWaveFormManager().getWaveForm((int)0).wfi.ci.getVoltbaseIndex();
        jComboBox.setSelectedIndex(n2);
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!ArgTypePane.this.isListening()) {
                    return;
                }
                if (itemEvent.getStateChange() == 1) {
                    ArgTypePane.this.onVbChanged();
                }
            }
        });
        jComboBox.setMaximumRowCount(20);
        new ComboboxMouseWheelSupport(jComboBox);
        container.add(jComboBox);
        CButton cButton = new CButton();
        cButton.setPreferredSize(new Dimension(38, 32));
        cButton.setText("-");
        cButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Math.max(0, jComboBox.getSelectedIndex() - 1);
                jComboBox.setSelectedIndex(n);
            }
        });
        CButton cButton2 = new CButton();
        cButton2.setPreferredSize(cButton.getPreferredSize());
        cButton2.setText("+");
        cButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Math.min(jComboBox.getItemCount() - 1, jComboBox.getSelectedIndex() + 1);
                jComboBox.setSelectedIndex(n);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(cButton);
        jPanel.add(cButton2);
        container.add(jPanel);
        return jComboBox;
    }

    protected void onVbChanged() {
        int n = this.vbcbb.getSelectedIndex();
        if (n < 0) {
            return;
        }
        for (Component component : this.getParent().getComponents()) {
            if (!(component instanceof ArgTypePane)) continue;
            ((ArgTypePane)component).contentUpdate(n);
        }
        int n2 = this.cmdt.channelNumber;
        while (--n2 >= 0) {
            this.ttd.vbChangeForChannel(n2, n);
        }
    }

    public void refreshContentWhileSuspend() {
        if (this.spinners == null) {
            return;
        }
        int n = this.cmdt.channelNumber;
        for (int i = 0; i < n; ++i) {
            int n2 = this.cmdt.getArgs()[i][this.vbcbb.getSelectedIndex()];
            this.spinners[i].setValue(n2);
        }
    }

    @Override
    public void sync2Device() {
        int n = this.cmdt.channelNumber;
        int n2 = this.vbcbb.getSelectedIndex();
        for (int i = 0; i < n; ++i) {
            int n3;
            this.cmdt.getArgs()[i][n2] = n3 = this.spinners[i].getValue();
            this.ttd.argChange(this.cmdt.getId(), i, n2);
        }
    }

    protected CompositeSpin createESpin(Container container, final int n, final JComboBox jComboBox) {
        final int n2 = this.cmdt.getId();
        CompositeSpin compositeSpin = new CompositeSpin(this){

            @Override
            public void spinValueChange() {
                int n3;
                int n22 = jComboBox.getSelectedIndex();
                ArgTypePane.this.cmdt.getArgs()[n][n22] = n3 = this.getValue();
                String string = (Object)((Object)ArgType.VALUES[n2]) + "args[" + n + "][" + n22 + "] = " + n3;
                System.out.println(string);
                ArgTypePane.this.ttd.argChange(n2, n, n22);
            }
        };
        container.add(compositeSpin);
        return compositeSpin;
    }

    @Override
    public void createContent(IntVolt[] intVoltArray) {
        this.create(this, intVoltArray);
        this.listening = true;
    }
}

