/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.tune;

import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.core.tune.IntVolt;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.vds.calibration.CalibrationRunner;
import com.owon.vds.tiny.firm.pref.DefaultPrefControl;
import com.owon.vds.tiny.firm.pref.PrefNativeJSONStorage;
import com.owon.vds.tiny.firm.pref.model.ArgType;
import com.owon.vds.tiny.firm.pref.model.TuneModel;
import com.owon.vds.tiny.firm.pref.model.TuneTexter;
import com.owon.vds.tiny.tune.ITuneFunction;
import com.owon.vds.tiny.tune.TinyTuneDelegate;
import com.owon.vds.tiny.tune.detail.AbsCalArgType;
import com.owon.vds.tiny.tune.detail.DefaultCalArgType;
import com.owon.vds.tiny.ui.tune.ArgTypePane;
import com.owon.vds.tiny.ui.tune.TinyTuneDialog;
import com.owon.vds.tiny.ui.tune.control.DefaultTinyTuneDelegate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TinyTuneFunction
implements ITuneFunction {
    private int tid = 0;
    private String[] channels;
    public IntVolt[] ios;
    public int vlen;
    private TinyTuneDelegate ttd;
    private TuneModel tm;
    private DefaultPrefControl dpc;
    public AbsCalArgType cmdt;
    private TinyTuneDialog tunewnd;

    public IntVolt[] getIntVolts() {
        return this.ios;
    }

    public String[] getChannelNames() {
        return this.channels;
    }

    public TinyTuneDelegate getTinyTuneDelegate() {
        return this.ttd;
    }

    public TuneModel getTuneModel() {
        return this.tm;
    }

    public DefaultPrefControl getDefaultPrefControl() {
        return this.dpc;
    }

    public TinyTuneFunction(int n, int[] nArray) {
        int n2;
        this.channels = new String[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.channels[n2] = "CH" + (n2 + 1);
        }
        this.vlen = nArray.length;
        this.ios = new IntVolt[this.vlen];
        for (n2 = 0; n2 < this.vlen; ++n2) {
            this.ios[n2] = new IntVolt(nArray[n2]);
        }
        this.tm = this.createTuneModel(n, this.vlen);
        PrefNativeJSONStorage prefNativeJSONStorage = new PrefNativeJSONStorage();
        this.dpc = new DefaultPrefControl(this.tm, prefNativeJSONStorage);
        this.ttd = new DefaultTinyTuneDelegate(this.dpc);
        this.tid = 0;
        if (this.tid >= this.tm.cmdts.size()) {
            this.tid = 0;
        }
        this.cmdt = this.tm.cmdts.get(this.tid);
        this.tm.setPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("tune_vbbChange")) {
                    if (TinyTuneFunction.this.tunewnd == null) {
                        return;
                    }
                    ChannelInfo channelInfo = (ChannelInfo)propertyChangeEvent.getNewValue();
                    int n = channelInfo.getNumber();
                    int n2 = channelInfo.getVoltbaseIndex();
                    ArgTypePane argTypePane = TinyTuneFunction.this.tunewnd.getCurrentArgTypePane();
                    if (argTypePane != null) {
                        argTypePane.onVoltbaseChange(n, n2);
                    }
                } else if (string.equals("ArgsUpdate") && TinyTuneFunction.this.tunewnd != null) {
                    TinyTuneFunction.this.tunewnd.contentUpdateWithoutSync();
                }
            }
        });
    }

    protected TuneModel createTuneModel(int n, int n2) {
        return new TuneModel(n, n2);
    }

    public TuneTexter createTuneTexter() {
        return new TuneTexter(this.tm, this.channels, this.ios);
    }

    public void persist(Pref pref) {
        pref.persistInt("Tune.tid", this.tid);
    }

    public static String[] load(ResourceBundle resourceBundle) {
        String[] stringArray = new String[]{resourceBundle.getString("Internal.CMDType.CoarseGain"), resourceBundle.getString("Internal.CMDType.ZeroAmplitude"), resourceBundle.getString("Internal.CMDType.ZeroCompensation")};
        return stringArray;
    }

    @Override
    public JTabbedPane createTabs(Container container) {
        ResourceBundle resourceBundle = I18nProvider.bundle();
        String[] stringArray = TinyTuneFunction.load(resourceBundle);
        final JTabbedPane jTabbedPane = new JTabbedPane();
        int n = 0;
        for (String string : stringArray) {
            DefaultCalArgType defaultCalArgType = this.tm.cmdts.get(n);
            ArgTypePane argTypePane = new ArgTypePane(defaultCalArgType, this.ttd);
            argTypePane.setPreferredSize(new Dimension(400, 300));
            argTypePane.createContent(this.ios);
            argTypePane.contentUpdate();
            jTabbedPane.addTab(string, argTypePane);
            ++n;
        }
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = jTabbedPane.getSelectedIndex();
                TinyTuneFunction.this.cmdt = ((TinyTuneFunction)TinyTuneFunction.this).tm.cmdts.get(n);
                TinyTuneFunction.this.tid = n;
                TinyTuneFunction.this.initState(ArgType.VALUES[TinyTuneFunction.this.cmdt.getId()]);
            }
        });
        container.add((Component)jTabbedPane, "Center");
        jTabbedPane.setSelectedIndex(this.tid);
        return jTabbedPane;
    }

    public void initState(ArgType argType) {
        int n = 0;
        int n2 = 0;
        switch (argType) {
            case Gain: {
                n2 = 0;
                n = 0;
                break;
            }
            case Step: {
                n2 = 1;
                n = CalibrationRunner.ZEROSTEPCAL_BASE;
                break;
            }
            case Compensation: {
                n2 = 1;
                n = 0;
            }
        }
        WaveFormInfoControl waveFormInfoControl = Platform.getControlManager().getWaveFormInfoControl();
        int n3 = waveFormInfoControl.getLowMachineChannels();
        for (int i = 0; i < n3; ++i) {
            ChannelInfo channelInfo = waveFormInfoControl.getWaveFormChannelInfo(i);
            channelInfo.c_setCoupling(n2);
            channelInfo.c_setInverse(false);
            this.ttd.posChangeForChannel(i, n);
        }
    }

    @Override
    public void doselfcorrect() {
        this.ttd.selfCalibration();
    }

    public void open(Window window) {
        if (this.tunewnd == null) {
            this.tunewnd = new TinyTuneDialog(this, window);
        } else {
            this.tunewnd.toFront();
        }
    }

    @Override
    public void release() {
        this.tunewnd = null;
    }

    public void backupFlashMemory() {
        this.createTuneTexter().output(new File(TuneTexter.SETTINGS_DIR, "device-settings.txt"));
    }

    private void logln(String string) {
        System.out.println(string);
    }
}

