/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.firm.pref.model;

import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.vds.core.tune.IntVolt;
import com.owon.uppersoft.vds.core.tune.StringRoller;
import com.owon.vds.tiny.firm.pref.model.TuneModel;
import com.owon.vds.tiny.tune.detail.DefaultCalArgType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class TuneTexter {
    private TuneModel tm;
    private String[] chlnames;
    private IntVolt[] volts;
    public static final String SETTINGS = "device-settings.txt";
    public static final String SETTINGS_DEFAULT = "device-settings-default.txt";
    public static final String SETTINGS_DIR = Platform.DATA_DIR;

    public TuneTexter(TuneModel tuneModel, String[] stringArray, IntVolt[] intVoltArray) {
        this.tm = tuneModel;
        this.chlnames = stringArray;
        this.volts = intVoltArray;
    }

    public void output(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "GBK"));
            bufferedWriter.write("$flash_txt=1;");
            bufferedWriter.write("\r\n");
            bufferedWriter.write("\r\n");
            for (DefaultCalArgType defaultCalArgType : this.tm.cmdts) {
                bufferedWriter.write("//");
                bufferedWriter.write(defaultCalArgType.getType());
                bufferedWriter.write("\r\n");
                this.output(defaultCalArgType, bufferedWriter);
                bufferedWriter.write("\r\n");
            }
            bufferedWriter.write("\r\n");
            bufferedWriter.write("\r\n");
            this.tm.reg.writetxt(bufferedWriter);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("\r\n");
            bufferedWriter.write("END");
            bufferedWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void output(DefaultCalArgType defaultCalArgType, BufferedWriter bufferedWriter) throws IOException {
        String string = defaultCalArgType.prekey();
        int[][] nArray = defaultCalArgType.getArgs();
        int n = nArray[0].length;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.write2CHInfos(nArray, bufferedWriter, string, i, j);
            }
            bufferedWriter.write("\r\n");
        }
    }

    private void write2CHInfos(int[][] nArray, BufferedWriter bufferedWriter, String string, int n, int n2) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.write(String.valueOf(this.chlnames[n]));
        bufferedWriter.write("_");
        bufferedWriter.write(this.volts[n2].toString());
        bufferedWriter.write("=");
        bufferedWriter.write(String.valueOf(nArray[n][n2]));
        bufferedWriter.write(";");
        bufferedWriter.write("\r\n");
    }

    public void input(int[][] nArray, DefaultCalArgType defaultCalArgType, String string, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        StringRoller stringRoller = new StringRoller(string, defaultCalArgType.prekey().length());
        stringRoller.nextWord();
        n2 = stringRoller.fineWord(this.chlnames);
        stringRoller.nextWord();
        n3 = stringRoller.fineWord(this.volts);
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        nArray[n2][n3] = n;
    }

    public void save(String string) {
        this.output(new File(string));
    }

    public void save(File file) {
        this.output(file);
    }

    public boolean resetup() {
        return this.resetup(SETTINGS_DEFAULT);
    }

    public boolean resetup(String string) {
        File file = new File(SETTINGS_DIR, string);
        return this.loadDevicePref(file);
    }

    public boolean resetup(File file) {
        return this.loadDevicePref(file);
    }

    public boolean loadDevicePref(File file) {
        if (!file.isFile()) {
            return false;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
            String string = bufferedReader.readLine();
            if (!string.startsWith("$flash_txt")) {
                bufferedReader.close();
                return false;
            }
            block3: while ((string = bufferedReader.readLine()) != null && !string.equalsIgnoreCase("END")) {
                String string2;
                if (string.length() == 0 || string.startsWith("//")) continue;
                int n = string.indexOf("=");
                int n2 = string.indexOf(";");
                String string3 = string.substring(0, n).trim();
                if (this.tm.reg.readtxtline(string3, string2 = string.substring(n + 1, n2).trim())) continue;
                Integer n3 = Integer.parseInt(string2);
                for (DefaultCalArgType defaultCalArgType : this.tm.cmdts) {
                    int[][] nArray = defaultCalArgType.getArgs();
                    if (!string3.startsWith(defaultCalArgType.prekey())) continue;
                    this.input(nArray, defaultCalArgType, string3, n3);
                    continue block3;
                }
            }
            bufferedReader.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }
}

