/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.firm.pref.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.vds.core.tune.Cending;
import com.owon.uppersoft.vds.device.interpret.util.Arrays2DUtil;
import com.owon.vds.tiny.firm.pref.CalsObject;
import com.owon.vds.tiny.firm.pref.DevicePref;
import com.owon.vds.tiny.firm.pref.model.ArgType;
import com.owon.vds.tiny.firm.pref.model.Register;
import com.owon.vds.tiny.tune.detail.AbsCalArgType;
import com.owon.vds.tiny.tune.detail.DefaultCalArgType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TuneModel
implements DevicePref {
    public List<DefaultCalArgType> cmdts;
    public Register reg = new Register();
    static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private PropertyChangeListener pcl;

    public TuneModel(int n, int n2) {
        this.cmdts = new ArrayList<DefaultCalArgType>();
        this.fillArgTypeList(this.cmdts, n, n2);
    }

    public String toString() {
        return gson.toJson(this);
    }

    protected void fillArgTypeList(List<DefaultCalArgType> list, int n, int n2) {
        DefaultCalArgType defaultCalArgType = new DefaultCalArgType(ArgType.Gain.ordinal(), Cending.ascending, n, n2);
        list.add(defaultCalArgType);
        DefaultCalArgType defaultCalArgType2 = new DefaultCalArgType(ArgType.Step.ordinal(), Cending.ascending, n, n2);
        list.add(defaultCalArgType2);
        DefaultCalArgType defaultCalArgType3 = new DefaultCalArgType(ArgType.Compensation.ordinal(), Cending.descending, n, n2);
        list.add(defaultCalArgType3);
    }

    public AbsCalArgType getSimpleAdjustCMDType(int n) {
        return this.cmdts.get(n);
    }

    public int getAbsCalArgTypeNumber() {
        return this.cmdts.size();
    }

    public Register getRegister() {
        return this.reg;
    }

    @Override
    public String getSerialNumber() {
        return this.reg.serialNumber;
    }

    @Override
    public void wrRegister(ByteBuffer byteBuffer) {
        this.reg.write(byteBuffer);
    }

    @Override
    public void rdRegister(ByteBuffer byteBuffer) {
        this.reg.read(byteBuffer);
        System.out.println("flash oem: " + this.reg.oem);
        System.out.println("flash board version: " + this.reg.version);
        System.out.println("flash board serial: " + this.reg.serialNumber);
    }

    @Override
    public void writeArgsAtPartitionBuffer(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.position();
        for (n = 0; n < this.getAbsCalArgTypeNumber(); ++n) {
            AbsCalArgType absCalArgType = this.getSimpleAdjustCMDType(n);
            this.logln(absCalArgType.getType());
            int[][] nArray = absCalArgType.getArgs();
            Arrays2DUtil.fillBytes(byteBuffer, nArray);
        }
        n = byteBuffer.position();
        this.logln(n2 + ", " + n);
    }

    private void logln(String string) {
        System.out.println(string);
        Platform.getControlManager().pcs.firePropertyChange("APPEND_TXTLINE", null, string);
    }

    @Override
    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcl = propertyChangeListener;
    }

    @Override
    public void readArgsFromPartitionBuffer(ByteBuffer byteBuffer) {
        for (int i = 0; i < this.getAbsCalArgTypeNumber(); ++i) {
            AbsCalArgType absCalArgType = this.getSimpleAdjustCMDType(i);
            int[][] nArray = absCalArgType.getArgs();
            Arrays2DUtil.loadFromBytes(nArray, byteBuffer, (short)0);
            for (int j = 0; j < nArray.length; ++j) {
                System.out.println(absCalArgType.getType() + " CH" + j + " : " + Arrays.toString(nArray[j]));
            }
        }
        if (this.pcl != null) {
            this.pcl.propertyChange(new PropertyChangeEvent(this, "ArgsUpdate", null, null));
        }
    }

    @Override
    public void readArgsFromObject(CalsObject calsObject) {
        List<int[][]> list = calsObject.cals;
        for (int i = 0; i < list.size(); ++i) {
            int[][] nArray = list.get(i);
            AbsCalArgType absCalArgType = this.getSimpleAdjustCMDType(i);
            absCalArgType.setArgs(nArray);
            for (int j = 0; j < nArray.length; ++j) {
                System.out.println(absCalArgType.getType() + " CH" + j + " : " + Arrays.toString(nArray[j]));
            }
        }
        if (this.pcl != null) {
            this.pcl.propertyChange(new PropertyChangeEvent(this, "ArgsUpdate", null, null));
        }
    }

    @Override
    public CalsObject getArgsAsObject() {
        CalsObject calsObject = new CalsObject();
        ArrayList<int[][]> arrayList = new ArrayList<int[][]>(3);
        int n = 0;
        arrayList.add(this.getSimpleAdjustCMDType(n++).getArgs());
        arrayList.add(this.getSimpleAdjustCMDType(n++).getArgs());
        arrayList.add(this.getSimpleAdjustCMDType(n++).getArgs());
        calsObject.cals = arrayList;
        return calsObject;
    }
}

