/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.firm.pref.model;

import com.owon.uppersoft.vds.data.LocaleObject;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.vds.tiny.firm.pref.model.PhaseFine;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Register {
    public static final int REG_LOCALE_LEN = 100;
    private static final String[] localeTypes = new String[]{"zh_CN", "zh_TW", "en", "fr", "es", "ru", "de", "pl", "pt_BR", "it", "ja", "ko_KR"};
    public static final List<LocaleObject> localeLists = new ArrayList<LocaleObject>(localeTypes.length);
    public boolean oem;
    public String version = "";
    public String serialNumber = "";
    public List<Boolean> localeSelection = new ArrayList<Boolean>(localeTypes.length);
    private PhaseFine pf = new PhaseFine();
    private static final String versionkey = "version";
    private static final String serieskey = "series";
    private static final String phase_fine_key = "phase_fine_value";
    private static final String oemkey = "oemlogo";
    private static final String newline = "\r\n";

    public static final LocaleObject getLocaleObject(String string) {
        return new LocaleObject(Pref.forLocale(string));
    }

    public static final String getString(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byte by = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (byteBuffer.hasRemaining() && (by = byteBuffer.get()) != 0) {
            stringBuffer.append((char)by);
            if (++n2 <= 100) continue;
            byteBuffer.position(byteBuffer.limit());
            return "...";
        }
        return stringBuffer.toString();
    }

    public Register() {
        int n = localeTypes.length;
        for (int i = 0; i < n; ++i) {
            this.localeSelection.add(Boolean.FALSE);
        }
    }

    public List<LocaleObject> getSelectedLocaleObject() {
        LinkedList<LocaleObject> linkedList = new LinkedList<LocaleObject>();
        int n = this.localeSelection.size();
        for (int i = 0; i < n; ++i) {
            if (!this.localeSelection.get(i).booleanValue()) continue;
            linkedList.add(localeLists.get(i));
        }
        return linkedList;
    }

    public void read(ByteBuffer byteBuffer) {
        this.oem = byteBuffer.get() != 0;
        this.version = Register.getString(byteBuffer);
        this.serialNumber = Register.getString(byteBuffer);
        if (byteBuffer.remaining() > 102) {
            int n = byteBuffer.position();
            int n2 = this.localeSelection.size();
            for (int i = 0; i < n2 && byteBuffer.hasRemaining(); ++i) {
                this.localeSelection.set(i, byteBuffer.get() != 0);
            }
            byteBuffer.position(n + 100);
            this.pf.setRdValue(byteBuffer.getShort());
        }
    }

    public void write(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)(this.oem ? 1 : 0));
        try {
            byte[] byArray = this.version.getBytes("ASCII");
            byteBuffer.put(byArray, 0, byArray.length);
            byteBuffer.put((byte)0);
            byArray = this.serialNumber.getBytes("ASCII");
            byteBuffer.put(byArray, 0, byArray.length);
            byteBuffer.put((byte)0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return;
        }
        int n = byteBuffer.position();
        int n2 = this.localeSelection.size();
        for (int i = 0; i < n2; ++i) {
            byteBuffer.put((byte)(this.localeSelection.get(i) != false ? 1 : 0));
        }
        byteBuffer.position(n + 100);
        byteBuffer.putShort(this.pf.getWrValue());
    }

    public PhaseFine getPhaseFine() {
        return this.pf;
    }

    public void enableLanguage(String string) {
        int n = localeLists.size();
        for (int i = 0; i < n; ++i) {
            LocaleObject localeObject = localeLists.get(i);
            String string2 = localeObject.getLocale().toString();
            if (!string2.equals(string)) continue;
            this.localeSelection.set(i, Boolean.TRUE);
            return;
        }
    }

    boolean isTrue(String string) {
        return !string.equalsIgnoreCase("0");
    }

    public boolean readtxtline(String string, String string2) {
        if (!string.startsWith("@")) {
            return false;
        }
        if ((string = string.substring(1)).equals(versionkey)) {
            this.version = string2;
        } else if (string.equals(serieskey)) {
            this.serialNumber = string2;
        } else if (string.equals(oemkey)) {
            this.oem = this.isTrue(string2);
        } else if (string.equals(phase_fine_key)) {
            this.pf.setRdValue(Short.valueOf(string2));
        } else {
            LocaleObject localeObject = Register.getLocaleObject(string);
            int n = localeLists.indexOf(localeObject);
            if (n >= 0) {
                this.localeSelection.set(n, this.isTrue(string2));
            }
        }
        return true;
    }

    public void writetxt(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("@version=" + this.version + ";");
        bufferedWriter.write("\t//\u7248\u672c\u4fe1\u606f\uff08\u4e2d\u6587\uff09");
        bufferedWriter.write(newline);
        bufferedWriter.write("@series=" + this.serialNumber + ";");
        bufferedWriter.write("\t//\u5e8f\u5217\u53f7\uff08\u4e2d\u6587\uff09");
        bufferedWriter.write(newline);
        bufferedWriter.write("@oemlogo=" + (this.oem ? 1 : 0) + ";");
        bufferedWriter.write("\t//OEM \u7684Logo\u5f00\u5173");
        bufferedWriter.write(newline);
        bufferedWriter.write("@phase_fine_value=" + this.pf.getWrValue() + ";");
        bufferedWriter.write(newline);
        bufferedWriter.write(newline);
        bufferedWriter.write("//");
        bufferedWriter.write(newline);
        int n = localeLists.size();
        for (int i = 0; i < n; ++i) {
            LocaleObject localeObject = localeLists.get(i);
            String string = localeObject.getLocale().toString();
            bufferedWriter.write("@" + string + "=" + (this.localeSelection.get(i) != false ? 1 : 0) + ";");
            bufferedWriter.write("\t");
            if (string.length() <= 2) {
                bufferedWriter.write("\t");
            }
            bufferedWriter.write("//" + localeObject.getDisplayNameForChs() + "\u8bed\u8a00\u5f00\u5173");
            bufferedWriter.write(newline);
        }
    }

    public int setPhaseFineValue(boolean bl, short s) {
        this.pf.setPhaseFineValue(bl, s);
        return this.pf.getWrValue();
    }

    static {
        int n = localeTypes.length;
        for (int i = 0; i < n; ++i) {
            localeLists.add(Register.getLocaleObject(localeTypes[i]));
        }
    }
}

