/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.firm.pref;

import com.owon.uppersoft.dso.global.Platform;
import com.owon.vds.tiny.firm.pref.CalsObject;
import com.owon.vds.tiny.firm.pref.PrefNativeStorage;
import com.owon.vds.util.Gsons;
import java.io.File;

public class PrefNativeJSONStorage
implements PrefNativeStorage {
    private static String CALIBRATION = "-cals.json";

    @Override
    public CalsObject getDevicePartCalsObject(String string) {
        File file = this.getFile(CALIBRATION, string);
        if (file.exists() && file.isFile()) {
            System.out.println("load calibration " + file.getPath());
            return Gsons.load(file, CalsObject.class);
        }
        return null;
    }

    @Override
    public void write2DevicePart(String string, CalsObject calsObject) {
        if (string == null || string.length() == 0) {
            return;
        }
        File file = this.getFile(CALIBRATION, string);
        Gsons.persist(file, calsObject);
    }

    public void write2FactoryPart(String string, CalsObject calsObject) {
        throw new UnsupportedOperationException();
    }

    private File getFile(String string, String string2) {
        return new File(Platform.DATA_DIR, string2 + string);
    }

    public static void main(String[] stringArray) {
        PrefNativeJSONStorage prefNativeJSONStorage = new PrefNativeJSONStorage();
        CalsObject calsObject = CalsObject.mock();
        String string = "VDS1022I1616402";
        prefNativeJSONStorage.write2DevicePart(string, calsObject);
        CalsObject calsObject2 = prefNativeJSONStorage.getDevicePartCalsObject(string);
        calsObject2.print_self();
    }
}

