/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.firm.pref;

import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.util.BufferHandleUtil;
import com.owon.vds.tiny.firm.FlashMirror;
import com.owon.vds.tiny.firm.pref.CalsObject;
import com.owon.vds.tiny.firm.pref.DevicePref;
import com.owon.vds.tiny.firm.pref.PrefControl;
import com.owon.vds.tiny.firm.pref.PrefNativeStorage;
import java.nio.ByteBuffer;

public class DefaultPrefControl
implements PrefControl,
Logable {
    private DevicePref devPrefModel;
    private FlashMirror flashMirror;
    private PrefNativeStorage nativeStore;
    private static final int FACTORYSET_LEN = 200;

    public DefaultPrefControl(DevicePref devicePref, PrefNativeStorage prefNativeStorage) {
        this.devPrefModel = devicePref;
        this.nativeStore = prefNativeStorage;
        this.flashMirror = new FlashMirror();
    }

    @Override
    public byte[] outputAsSyncImage() {
        return this.flashMirror.array();
    }

    @Override
    public void save2DevicePart() {
        this.nativeStore.write2DevicePart(this.devPrefModel.getSerialNumber(), this.devPrefModel.getArgsAsObject());
    }

    @Override
    public void rollFactory2Device() {
        this.logln("restore factory settings");
        ByteBuffer byteBuffer = this.flashMirror.getFactoryPartition_LE();
        this.devPrefModel.readArgsFromPartitionBuffer(byteBuffer);
        this.save2DevicePart();
    }

    @Override
    public void saveRegistry() {
        this.wrRegister();
    }

    @Override
    public void updateFlashMirror() {
        this.logln("wrDevicePref2FactorySetPref");
        this.save2DevicePart();
        ByteBuffer byteBuffer = this.flashMirror.getFactoryPartition_LE();
        this.devPrefModel.writeArgsAtPartitionBuffer(byteBuffer);
        this.wrRegister();
    }

    private void wrRegister() {
        ByteBuffer byteBuffer = this.flashMirror.getFactoryPartition_LE();
        BufferHandleUtil.skipByteBuffer(byteBuffer, 200);
        this.devPrefModel.wrRegister(byteBuffer);
    }

    private void rdRegister() {
        ByteBuffer byteBuffer = this.flashMirror.getFactoryPartition_LE();
        BufferHandleUtil.skipByteBuffer(byteBuffer, 200);
        this.devPrefModel.rdRegister(byteBuffer);
    }

    @Override
    public boolean loadSyncImageFromDevice(byte[] byArray) {
        this.flashMirror.loadDevPref(byArray);
        this.rdRegister();
        String string = this.devPrefModel.getSerialNumber();
        CalsObject calsObject = this.nativeStore.getDevicePartCalsObject(string);
        if (calsObject != null) {
            this.devPrefModel.readArgsFromObject(calsObject);
        } else {
            this.log("load calibration from flash");
            ByteBuffer byteBuffer = this.flashMirror.getFactoryPartition_LE();
            this.devPrefModel.readArgsFromPartitionBuffer(byteBuffer);
            CalsObject calsObject2 = this.devPrefModel.getArgsAsObject();
            this.nativeStore.write2DevicePart(string, calsObject2);
        }
        return true;
    }

    @Override
    public void log(Object object) {
        System.out.print(object);
    }

    @Override
    public void logln(Object object) {
        System.out.println(object);
    }
}

