/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.firm;

import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.util.BufferHandleUtil;
import com.owon.uppersoft.vds.util.format.EndianUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class FlashMirror
implements Logable {
    private byte[] flashArray = new byte[2002];
    private static int DEVPREF_PTC_VER = 2;
    private static int DEVPREF_PTC_VER_LEN = 4;
    private static int DEVPREF_READ_ONLY_LEN = 1000;

    public byte[] array() {
        EndianUtil.writeIntL(this.flashArray, 2, DEVPREF_PTC_VER);
        return this.flashArray;
    }

    private ByteBuffer prepareRawPartition_LE() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.flashArray, 0, this.flashArray.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        BufferHandleUtil.skipByteBuffer(byteBuffer, 2 + DEVPREF_PTC_VER_LEN);
        return byteBuffer;
    }

    public ByteBuffer getFactoryPartition_LE() {
        this.logln("getFactoryPartition_LE");
        ByteBuffer byteBuffer = this.prepareRawPartition_LE();
        byteBuffer.limit(byteBuffer.position() + DEVPREF_READ_ONLY_LEN);
        return byteBuffer;
    }

    public ByteBuffer getDeviceArgPartition_LE() {
        this.logln("getDeviceArgPartition_LE");
        ByteBuffer byteBuffer = this.prepareRawPartition_LE();
        BufferHandleUtil.skipByteBuffer(byteBuffer, DEVPREF_READ_ONLY_LEN);
        return byteBuffer;
    }

    public boolean loadDevPref(byte[] byArray) {
        byte[] byArray2 = this.flashArray;
        if (byArray == null || byArray.length != byArray2.length) {
            return false;
        }
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        byte by = byArray2[0];
        byte by2 = byArray2[1];
        System.out.println(String.format("flash header: 0x%02X 0x%02X", by, by2));
        if (by != -86 || by2 != 85) {
            return false;
        }
        int n = EndianUtil.nextIntL(byArray2, 2);
        System.out.println("flash version: " + n);
        return n == DEVPREF_PTC_VER;
    }

    public static void memset(ByteBuffer byteBuffer, int n) {
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        Arrays.fill(byArray, n2, n3, (byte)n);
    }

    @Override
    public void log(Object object) {
    }

    @Override
    public void logln(Object object) {
    }
}

