/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.firm;

import com.owon.uppersoft.dso.function.SoftwareControl;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.core.comm.ICommunicateManager;
import com.owon.uppersoft.vds.device.interpret.util.Sendable;
import com.owon.uppersoft.vds.util.format.EndianUtil;
import com.owon.vds.firm.protocol.AddValueAttachCommand;
import com.owon.vds.firm.protocol.AddressAttachCommand;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class FPGADownloader
implements Logable {
    public static final String FPD_NOFILE = "FPD_NOFILE";
    public static final String FPD_SENDFILESIZE = "FPD_SENDFILESIZE";
    public static final String FPD_QUERY_BUFSIZE = "FPD_QUERY_BUFSIZE";
    public static final String FPD_QUERYSIZE_ERR = "FPD_QUERYSIZE_ERR";
    public static final String FPD_START_SEND = "FPD_START_SEND";
    public static final String FPD_SEND_LENGTH = "FPD_SEND_LENGTH";
    public static final String FPD_RESPONSE = "FPD_RESPONSE";
    public static final String FPD_DONE = "FPD_DONE";
    public static final String FPD_SENDSIZE_ERR = "FPD_SENDSIZE_ERR";
    public static File FPGA_DIR = new File(Platform.APP_DIR, "fwr");
    public static final AddressAttachCommand FPGA_DOWNLOAD_ADD = new AddressAttachCommand("FPGA_DOWNLOAD_ADD", 16384, 4);
    public static final AddValueAttachCommand FPGA_DOWNLOAD_QUERY_ADD = new AddValueAttachCommand("FPGA_DOWNLOAD_QUERY_ADD", 547, 1, 0);

    @Override
    public void log(Object object) {
        System.out.print(object);
    }

    @Override
    public void logln(Object object) {
        System.out.println(object);
    }

    public File checkFPGAAvailable(String string, String string2) {
        String string3 = string.toUpperCase() + "_FPGA";
        if (string3.startsWith("VDS1022")) {
            string3 = string3 + "V" + SoftwareControl.firmware;
        }
        for (File file : FPGA_DIR.listFiles()) {
            String string4 = file.getName().toUpperCase();
            if (!string4.endsWith(".BIN") || !string4.startsWith(string3)) continue;
            return file;
        }
        return null;
    }

    public int queryFPGADownloaded(ICommunicateManager iCommunicateManager) {
        int n = 5;
        byte[] byArray = new byte[n];
        int n2 = Sendable.interCommmands(iCommunicateManager, FPGA_DOWNLOAD_QUERY_ADD, byArray, this);
        if (n2 < 0) {
            return n2;
        }
        int n3 = EndianUtil.nextIntL(byArray, 1);
        this.logln("fpga loaded: " + n3);
        return Math.abs(n3);
    }

    public boolean downloadFPGA(PropertyChangeListener propertyChangeListener, ICommunicateManager iCommunicateManager, File file) {
        this.logln("load fpga " + file.getPath());
        int n = (int)file.length();
        int n2 = 5;
        int n3 = 5;
        propertyChangeListener.propertyChange(new PropertyChangeEvent(this, FPD_SENDFILESIZE, -1, n));
        ByteBuffer byteBuffer = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
        AddressAttachCommand addressAttachCommand = FPGA_DOWNLOAD_ADD;
        byteBuffer.putInt(addressAttachCommand.address);
        byteBuffer.put((byte)addressAttachCommand.bytes);
        byteBuffer.putInt(n);
        byte[] byArray = byteBuffer.array();
        int n4 = byteBuffer.position();
        int n5 = iCommunicateManager.write(byArray, n4);
        if (n5 <= 0) {
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, FPD_SENDSIZE_ERR, null, null));
            return false;
        }
        propertyChangeListener.propertyChange(new PropertyChangeEvent(this, FPD_QUERY_BUFSIZE, null, null));
        int n6 = iCommunicateManager.acceptResponse(byArray, n2);
        if (n6 <= 0) {
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, FPD_QUERYSIZE_ERR, -1, n6));
            return false;
        }
        int n7 = EndianUtil.nextIntL(byArray, 1);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        byte[] byArray2 = new byte[n7];
        int n11 = n7 - 4;
        propertyChangeListener.propertyChange(new PropertyChangeEvent(this, FPD_START_SEND, -1, n));
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            int n12 = n;
            int n13 = (n12 + n11 - 1) / n11;
            while (n8 < n12) {
                int n14 = n11;
                if (n12 - n8 < n11) {
                    n14 = n12 - n8;
                }
                this.log("[Send FPGA part " + (n9 + 1) + "/" + n13 + " ]");
                EndianUtil.writeIntL(byArray2, 0, n9);
                randomAccessFile.read(byArray2, 4, n14);
                propertyChangeListener.propertyChange(new PropertyChangeEvent(this, FPD_SEND_LENGTH, -1, n14));
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                iCommunicateManager.write(byArray2, byArray2.length);
                Arrays.fill(byArray, (byte)0);
                int n15 = iCommunicateManager.acceptResponse(byArray, n4);
                int n16 = EndianUtil.nextIntL(byArray, 1);
                this.logln(" recv: " + (char)byArray[0] + " " + n16);
                if (n15 < 0 || byArray[0] != 83) {
                    this.logln("FAILURE: FPGA part " + (n9 + 1) + "/" + n13 + " failed !");
                    ++n10;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    if (n10 < n3) continue;
                    break;
                }
                n8 += n14;
                ++n9;
            }
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, FPD_DONE, null, n12));
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }
}

