/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.firm;

import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.core.comm.ICommunicateManager;
import com.owon.uppersoft.vds.device.interpret.util.PackUtil2;
import com.owon.vds.firm.protocol.AddValueAttachCommand;
import java.util.zip.CRC32;

public class DeviceFlashCommunicator
implements Logable {
    public static final int FLASH_CONTENT_SIZE = 2000;
    public static final int FLASH_SIZE = 2002;
    public static final int DEVPREF_CRCSKIPBYTES = 2;
    public static final byte DEVPREF_WBYTE1 = -86;
    public static final byte DEVPREF_WBYTE0 = 85;
    public static final byte DEVPREF_RBYTE0 = -86;
    public static final byte DEVPREF_RBYTE1 = 85;
    public static final AddValueAttachCommand write_flash = new AddValueAttachCommand("write_flash", 416, 1, 1);
    public static final AddValueAttachCommand read_flash = new AddValueAttachCommand("read_flash", 432, 1, 1);

    protected long updateCRC32(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 2, 2000);
        long l = cRC32.getValue();
        return l;
    }

    @Override
    public void log(Object object) {
        System.out.print(object);
    }

    @Override
    public void logln(Object object) {
        System.out.println(object);
    }

    public byte[] fetchPrefernce(ICommunicateManager iCommunicateManager, boolean bl) {
        this.logln("read flash");
        int n = this.writeCommmand(iCommunicateManager, read_flash);
        if (n < 0) {
            return null;
        }
        byte[] byArray = new byte[2002];
        int n2 = iCommunicateManager.acceptResponse(byArray, byArray.length);
        if (n2 < 0) {
            return null;
        }
        this.logln("flash size: " + n2);
        if (n2 == 2002) {
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray, 2, 2000);
            long l = cRC32.getValue();
            this.logln("flash crc32: " + l);
            return byArray;
        }
        return null;
    }

    public boolean sendPrefernce(ICommunicateManager iCommunicateManager, byte[] byArray) {
        this.logln("write flash");
        if (this._sendPrefernce(iCommunicateManager, byArray)) {
            return true;
        }
        this.logln("ERROR: write flash failed!");
        return false;
    }

    private boolean _sendPrefernce(ICommunicateManager iCommunicateManager, byte[] byArray) {
        int n = this.writeCommmand(iCommunicateManager, write_flash);
        if (n < 0) {
            return false;
        }
        byte[] byArray2 = new byte[5];
        int n2 = iCommunicateManager.acceptResponse(byArray2, byArray2.length);
        if (n2 < 0) {
            return false;
        }
        byArray[0] = 85;
        byArray[1] = -86;
        this.log("send FLASH part 1/1");
        n = iCommunicateManager.write(byArray, 2002);
        if (n != 2002) {
            return false;
        }
        byArray2 = new byte[5];
        n2 = iCommunicateManager.acceptResponse(byArray2, byArray2.length);
        return n2 >= 0 && byArray2[0] == 83;
    }

    void printArray(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            System.out.print(String.valueOf(byArray[i]) + ",");
        }
    }

    protected int writeCommmand(ICommunicateManager iCommunicateManager, AddValueAttachCommand addValueAttachCommand) {
        byte[] byArray = PackUtil2.packCMD(addValueAttachCommand);
        return iCommunicateManager.write(byArray, byArray.length);
    }
}

