/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.circle;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.source.comm.InterCommTiny;
import com.owon.uppersoft.vds.ui.dialog.ProgressObserver;
import com.owon.vds.calibration.AutomaticWorkManager;
import com.owon.vds.calibration.stuff.ArgCreator;
import com.owon.vds.tiny.circle.AGPControl;
import com.owon.vds.tiny.circle.CalRunner2;
import com.owon.vds.tiny.circle.GainCal;
import com.owon.vds.tiny.circle.IWFCalRoutine2;
import java.beans.PropertyChangeSupport;

public class GainCalManager
extends AutomaticWorkManager {
    private AGPControl agp;
    private CalRunner2 gainCalRunner;

    public GainCalManager(ControlManager controlManager, InterCommTiny interCommTiny, DataHouse dataHouse, AGPControl aGPControl) {
        super(controlManager, interCommTiny, dataHouse);
        this.agp = aGPControl;
    }

    @Override
    protected void presetChannels() {
        this.cm.getWaveFormInfoControl().turnOnAllChannelsNotInverse(0);
    }

    @Override
    protected void getReadyForCalibration(ProgressObserver progressObserver, ArgCreator argCreator, PropertyChangeSupport propertyChangeSupport, Runnable runnable) {
        this.gainCalRunner = new CalRunner2(argCreator, progressObserver, runnable, propertyChangeSupport, this.agp){

            @Override
            protected int computeMaximum(int n, int n2) {
                return n2 * n;
            }

            @Override
            protected IWFCalRoutine2 createWFCalRoutine(int n, WaveForm waveForm, ArgCreator argCreator) {
                return new GainCal(waveForm, n, argCreator, GainCalManager.this.agp);
            }
        };
        this.gainCalRunner.getReady();
    }

    @Override
    public void cancel(Runnable runnable) {
        if (this.gainCalRunner != null) {
            this.gainCalRunner.cancel(runnable);
            this.gainCalRunner = null;
        }
    }

    @Override
    public void onFinished(ProgressObserver progressObserver) {
        super.onFinished(progressObserver);
        progressObserver.shutdown();
    }
}

