/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.circle;

import com.owon.uppersoft.dso.global.ControlApps;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.vds.machine.PrincipleTiny;
import com.owon.uppersoft.vds.machine.TinyMachine;
import com.owon.uppersoft.vds.source.comm.InterCommTiny;
import com.owon.uppersoft.vds.ui.dialog.ProgressExecutor;
import com.owon.uppersoft.vds.ui.dialog.ProgressObserver;
import com.owon.uppersoft.vds.ui.dialog.ProgressableDialog;
import com.owon.vds.calibration.stuff.ArgCreator;
import com.owon.vds.tiny.circle.AGPControl;
import com.owon.vds.tiny.circle.GainCalManager;
import com.owon.vds.tiny.firm.pref.PrefControl;
import java.awt.Window;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class GainCalDelegate
implements ProgressExecutor {
    protected Window wnd;
    protected ControlApps ca;
    protected ControlManager cm;
    private TinyMachine tm;
    private PrincipleTiny pt;
    public Runnable nextJob;
    private GainCalManager acm;
    private AGPControl agp;
    public boolean prompte;

    public GainCalDelegate(Window window, ControlApps controlApps, TinyMachine tinyMachine, PrincipleTiny principleTiny) {
        this.wnd = window;
        this.ca = controlApps;
        this.cm = controlApps.getControlManager();
        this.tm = tinyMachine;
        this.pt = principleTiny;
    }

    protected void circleCal(ProgressObserver progressObserver) {
        PrefControl prefControl = this.pt.getPrefControl();
        ArgCreator argCreator = this.tm.getArgCreator(this.pt.getCalArgTypeProvider());
        this.acm = new GainCalManager(this.cm, (InterCommTiny)this.ca.interComm, Platform.getDataHouse(), this.agp){

            @Override
            public void onFinished(ProgressObserver progressObserver) {
                super.onFinished(progressObserver);
                if (GainCalDelegate.this.nextJob != null) {
                    GainCalDelegate.this.nextJob.run();
                }
            }
        };
        this.acm.getReady(progressObserver, argCreator, prefControl);
    }

    @Override
    public void cancel(Runnable runnable) {
        if (this.acm != null) {
            this.acm.cancel(runnable);
            this.acm = null;
        }
    }

    @Override
    public void execute(final ProgressObserver progressObserver) {
        this.ca.getDaemon().addMission(new Runnable(){

            @Override
            public void run() {
                GainCalDelegate.this.circleCal(progressObserver);
            }

            public String toString() {
                return "m_circle";
            }
        });
    }

    public void askCircleCalibration(AGPControl aGPControl) {
        int n;
        if (this.agp != null) {
            this.agp.finish();
        }
        if (!this.cm.sourceManager.isConnected()) {
            return;
        }
        if (this.prompte && (n = JOptionPane.showConfirmDialog(this.wnd, I18nProvider.bundle().getString("M.Utility.SelfCorrecting.ConfirmTxt"), "", 0, 3)) != 0) {
            return;
        }
        this.ca.getOperateBlocker().block();
        if (this.cm.isRuntimeStop()) {
            this.ca.interComm.statusRun(false, true);
        }
        this.agp = aGPControl;
        ResourceBundle resourceBundle = I18nProvider.bundle();
        String string = resourceBundle.getString("Action.Cancel");
        String string2 = resourceBundle.getString("M.Utility.SelfCorrecting");
        String string3 = resourceBundle.getString("Label.Cancel");
        ProgressableDialog progressableDialog = new ProgressableDialog(this.wnd, true, this, string2, string, string3);
        progressableDialog.setVisible(true);
    }
}

