/*
 * Decompiled with CFR 0.152.
 */
package com.owon.vds.tiny.circle;

import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.vds.calibration.stuff.ArgCreator;
import com.owon.vds.calibration.stuff.CalculatUtil;
import com.owon.vds.tiny.circle.AGPControl;
import com.owon.vds.tiny.circle.GainArg;
import com.owon.vds.tiny.circle.IWFCalRoutine2;
import com.owon.vds.tiny.circle.TopBaseCalResult;
import java.nio.ByteBuffer;

public class GainCal
implements Logable,
IWFCalRoutine2 {
    private WaveForm wf;
    private int chl;
    private int vbnum;
    private ArgCreator ac;
    private AGPControl agp;
    private GainArg arg;
    private int TopCt = 0;
    private int baseCt = 0;
    private int tempVb;
    private int zeroPosition;

    public GainCal(WaveForm waveForm, int n, ArgCreator argCreator, AGPControl aGPControl) {
        this.wf = waveForm;
        this.chl = waveForm.getChannelNumber();
        this.vbnum = n;
        this.agp = aGPControl;
        this.ac = argCreator;
    }

    @Override
    public void getReady() {
    }

    @Override
    public void forVB(int n) {
        this.initNextGain(n);
    }

    @Override
    public int routOut() {
        ByteBuffer byteBuffer = this.wf.getADC_Buffer();
        TopBaseCalResult topBaseCalResult = CalculatUtil.computeTopBase(byteBuffer);
        int n = this.rout(topBaseCalResult);
        this.logln("result[" + this.chl + "] = " + n);
        return n;
    }

    @Override
    public int getRoutCalType() {
        if (this.arg != null) {
            return this.arg.id;
        }
        return -1;
    }

    private void initNextGain(int n) {
        this.logln("initNextGain " + n);
        if (n == 0) {
            this.wf.setZeroYLoc(0, true, false);
        }
        this.arg = this.ac.createGainArg(this.chl, n);
        this.wf.setVoltBaseIndex(n, false);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void setZero(TopBaseCalResult topBaseCalResult) {
        if (this.tempVb == this.arg.vb && this.arg.vb <= 1) {
            if (topBaseCalResult.top > 105) {
                ++this.TopCt;
                this.zeroPosition = this.TopCt * -20;
                this.wf.setZeroYLoc(this.zeroPosition, true, false);
                this.baseCt = 0;
            } else if (topBaseCalResult.base < -105) {
                ++this.baseCt;
                this.zeroPosition = this.baseCt * 20;
                this.wf.setZeroYLoc(this.zeroPosition, true, false);
                this.TopCt = 0;
            }
        } else {
            this.TopCt = 0;
            this.baseCt = 0;
            this.zeroPosition = 0;
            this.wf.setZeroYLoc(0, true, false);
        }
        this.tempVb = this.arg.vb;
    }

    private int rout(TopBaseCalResult topBaseCalResult) {
        this.logln("rout[" + this.chl + "] tb = " + topBaseCalResult);
        if (this.arg != null) {
            this.logln(this.arg);
        }
        this.setZero(topBaseCalResult);
        int n = topBaseCalResult.amp;
        if (this.arg.isTopBaseFit(n)) {
            if (!this.arg.increaseFitTimes()) {
                return 0;
            }
            this.arg = null;
            return 1;
        }
        if (this.arg.isTriesEnough()) {
            this.logln("too long time to cal, break");
            this.arg = null;
            return 1;
        }
        this.arg.resetFitTimes();
        this.argTuneAgain(n);
        return 0;
    }

    protected void nextGain() {
        int n = this.arg.vb + 1;
        if (n >= this.vbnum) {
            this.arg = null;
        } else {
            this.initNextGain(n);
        }
    }

    private void argTuneAgain(int n) {
        this.arg.stepCrease(n, this.arg.vb);
        this.wf.setVoltBaseIndex(this.arg.vb, false);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public void log(Object object) {
        System.err.print(object);
    }

    @Override
    public void logln(Object object) {
        System.err.println(object);
    }
}

